/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.profile;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.DateFormatter;
import com.equestricraft.core.club.Club;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.job.Job;
import com.equestricraft.core.job.jobrank.JobRank;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerTransformer;
import com.equestricraft.core.player.profile.PlayerProfileInfo;
import com.equestricraft.core.player.profile.PlayerProfileSession;
import com.equestricraft.core.rank.Rank;
import com.equestricraft.core.university.house.UniversityHouse;
import java.util.Optional;

public class PlayerProfileSessionImpl
implements PlayerProfileSession {
    @Service
    private HorseRepository horseRepository;
    @Service
    private PlayerTransformer playerTransformer;

    @Override
    public PlayerProfileInfo retrievePlayerProfile(ECPlayer player) {
        String joinDateString = DateFormatter.formatDateFull(player.getCorePlayer().getFirstSeen());
        boolean online = player.isOnline();
        String lastSeenString = online ? null : DateFormatter.formatDateFull(player.getCorePlayer().getLastSeen());
        Rank rank = player.getProgression().getRank();
        Optional<Job> job = player.getJob().getCurrent();
        String jobString = null;
        if (job.isPresent()) {
            JobRank jobRank = player.getJob().getRank().orElseThrow();
            jobString = job.map(info2 -> "&b" + jobRank.getName() + " " + ((Job)job.get()).getChatTag()).orElse(null);
        }
        Optional<UniversityHouse> house = player.getUniversity().getHouse();
        String houseString = house.map(UniversityHouse::getName).orElse(null);
        Optional<Club> club = player.getClub().getClub();
        String clubString = null;
        if (club.isPresent()) {
            clubString = club.get().getName() + " - " + player.getClub().getRankLabel();
        }
        int horseCount = player.getHorses().getLiving().size();
        return new PlayerProfileInfo(this.playerTransformer.toSimple(player.getCorePlayer()), joinDateString, online, lastSeenString, player.getProgression().getXp(), rank.getName(), rank.getColor(), jobString, houseString, clubString, horseCount, player.getCorePlayer().getRideStylePreference(), player.getCorePlayer().isDonator(), player.getCorePlayer().getDonatorLevel());
    }
}

