/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.progression;

import com.equestricraft.base.eventbus.ECEventBus;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.CachedValue;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.AbstractPlayerAccessor;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.progression.PlayerProgressionMilestoneInfo;
import com.equestricraft.core.player.progression.PlayerProgressionMilestoneSession;
import com.equestricraft.core.player.progression.ProgressionChangeEvent;
import com.equestricraft.core.player.rank.PlayerRankSession;
import com.equestricraft.core.player.xp.XPSession;
import com.equestricraft.core.rank.Rank;
import com.equestricraft.core.rank.RankSession;
import com.equestricraft.dataload.DataLoadModule;
import com.equestricraft.dataload.DataLoadSubscriber;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class PlayerProgressionAccessor
extends AbstractPlayerAccessor {
    @Service
    private static PlayerRankSession playerRankSession;
    @Service
    private static XPSession xpSession;
    @Service
    private static RankSession rankSession;
    @Service
    private static PlayerProgressionMilestoneSession playerProgressionMilestoneSession;
    private static final DataLoadSubscriber rankUpdateSubscriber;
    private final CachedValue<Rank> rank = new CachedValue<Rank>(this::getUpdatedRank);

    public PlayerProgressionAccessor(CorePlayer player) {
        super(player);
        rankUpdateSubscriber.subscribe(this.rank::expire);
    }

    public Rank getRank() {
        return this.rank.get();
    }

    public Optional<Integer> getXpUntilNextRank() {
        return playerRankSession.getXpUntilNextRank(this.player);
    }

    public void giveXp(int amount) {
        List<PlayerProgressionMilestoneInfo> previousMilestones = this.getMilestones();
        xpSession.giveXpToPlayer(this.player, amount);
        List<PlayerProgressionMilestoneInfo> nextMilestones = this.getMilestones();
        List<PlayerProgressionMilestoneInfo> unlockedMilestones = this.determineUnlockedMilestones(previousMilestones, nextMilestones);
        unlockedMilestones.stream().filter(PlayerProgressionMilestoneInfo::announce).forEach(m -> this.player.notify(I18n.getLabel("milestone.unlocked", m.name())));
        Rank rankForXp = rankSession.getRankForXp(this.getXp());
        if (!rankForXp.equals(this.rank.get())) {
            this.rank.set(rankForXp);
            this.player.notify(I18n.getLabel("rank.ranked-up", rankForXp.getName()));
        }
        Optional<Integer> xpUntilNext = this.getXpUntilNextRank();
        this.fireProgressionEvent(this.player, amount, rankForXp, xpUntilNext.orElse(null));
    }

    private List<PlayerProgressionMilestoneInfo> determineUnlockedMilestones(List<PlayerProgressionMilestoneInfo> previous, List<PlayerProgressionMilestoneInfo> next) {
        List<PlayerProgressionMilestoneInfo> previousUnlocked = previous.stream().filter(PlayerProgressionMilestoneInfo::unlocked).toList();
        return next.stream().filter(PlayerProgressionMilestoneInfo::unlocked).filter(Predicate.not(previousUnlocked::contains)).toList();
    }

    private void fireProgressionEvent(CorePlayer player, int changeValue, Rank currentRank, Integer xpUntilNext) {
        ProgressionChangeEvent event = new ProgressionChangeEvent(player, changeValue, player.getXp(), currentRank, xpUntilNext);
        ECEventBus.post(event);
    }

    public boolean takeXp(int amount) {
        return xpSession.takeXpFromPlayer(this.player, amount);
    }

    public int getXp() {
        return this.player.getXp();
    }

    public boolean hasXp(int amount) {
        return this.getXp() >= amount;
    }

    public List<PlayerProgressionMilestoneInfo> getMilestones() {
        return playerProgressionMilestoneSession.getAllPlayerProgressionMilestones(this.player);
    }

    private Rank getUpdatedRank() {
        return playerRankSession.getRankForPlayer(this.player);
    }

    static {
        rankUpdateSubscriber = new DataLoadSubscriber(DataLoadModule.RANKS);
    }
}

