/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.provision;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.inventory.PlayerInventoryProvider;
import com.equestricraft.core.player.provision.ProvisionInventoryItem;
import com.equestricraft.core.player.provision.ProvisionInventoryItemEntry;
import com.equestricraft.core.player.provision.ProvisionInventoryItemRepository;
import com.equestricraft.core.provision.Provision;
import com.equestricraft.core.provision.ProvisionRepository;
import java.util.Date;
import java.util.List;

public class PlayerProvisionInventoryProvider
implements PlayerInventoryProvider<ProvisionInventoryItemEntry> {
    @Service
    private ProvisionInventoryItemRepository provisionInventoryItemRepository;
    @Service
    private ProvisionRepository provisionRepository;

    @Override
    public List<ProvisionInventoryItemEntry> retrieveItemsForPlayer(ECPlayer player) {
        List<ProvisionInventoryItem> playersItems = this.provisionInventoryItemRepository.findInventoryItemsByPlayer(player.getId());
        List<Integer> provisionIds = playersItems.stream().map(ProvisionInventoryItem::getProvisionId).distinct().toList();
        List provisions = this.provisionRepository.findByKeys(provisionIds);
        return playersItems.stream().map(item -> {
            Provision provision = provisions.stream().filter(p -> p.getId() == item.getProvisionId()).findFirst().orElseThrow();
            return new ProvisionInventoryItemEntry(provision, item.getUnitsRemaining(), item.getUuid(), new Date(item.getAcquireTime()), new Date(item.getStartExpiryTime()), new Date(item.getEndExpiryTime()), item.getUnitsRemaining(), item.isSpoiled());
        }).toList();
    }
}

