/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.provision;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.player.provision.ProvisionInventoryItemRepository;
import java.util.Objects;
import java.util.UUID;

public class ProvisionInventoryItem
implements RepositoryEntity<UUID> {
    private final UUID uuid;
    private final int provisionId;
    private final int playerId;
    private final long acquireTime;
    private final Long startExpiryTime;
    private final Long endExpiryTime;
    private double unitsRemaining;
    private final boolean spoiled;

    public ProvisionInventoryItem(UUID uuid, int provisionId, int playerId, long acquireTime, Long startExpiryTime, Long endExpiryTime, double unitsRemaining, boolean spoiled) {
        this.uuid = uuid;
        this.provisionId = provisionId;
        this.playerId = playerId;
        this.acquireTime = acquireTime;
        this.startExpiryTime = startExpiryTime;
        this.endExpiryTime = endExpiryTime;
        this.unitsRemaining = unitsRemaining;
        this.spoiled = spoiled;
    }

    @Override
    public UUID getKey() {
        return this.getUuid();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public int getProvisionId() {
        return this.provisionId;
    }

    public int getPlayerId() {
        return this.playerId;
    }

    public long getAcquireTime() {
        return this.acquireTime;
    }

    public Long getStartExpiryTime() {
        return this.startExpiryTime;
    }

    public Long getEndExpiryTime() {
        return this.endExpiryTime;
    }

    public double getUnitsRemaining() {
        return this.unitsRemaining;
    }

    public void setUnitsRemaining(double unitsRemaining) {
        this.unitsRemaining = unitsRemaining;
    }

    public boolean isSpoiled() {
        return this.spoiled;
    }

    @Override
    public void save() {
        Services.getService(ProvisionInventoryItemRepository.class).update(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProvisionInventoryItem that = (ProvisionInventoryItem)o;
        return Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }
}

