/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.provision;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.player.provision.ProvisionInventoryItem;
import java.util.List;
import java.util.UUID;

public class ProvisionInventoryItemDatabase
implements RepositoryDatasource<ProvisionInventoryItem, UUID> {
    private static final String COLUMN_UUID = "UUID";
    private static final String COLUMN_PROVISION_ID = "PROVISION_ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_ACQUIRE_TIME = "ACQUIRE_TIME";
    private static final String COLUMN_START_EXPIRY_TIME = "START_EXPIRY_TIME";
    private static final String COLUMN_END_EXPIRY_TIME = "END_EXPIRY_TIME";
    private static final String COLUMN_UNITS_REMAINING = "UNITS_REMAINING";
    private static final String COLUMN_SPOILED = "SPOILED";

    @Override
    public void create(ProvisionInventoryItem provisionInventoryItem) {
        Query.insertInto("PROVISION_INVENTORY_ITEM").columns(QueryColumn.column(COLUMN_UUID, provisionInventoryItem.getUuid()), QueryColumn.column(COLUMN_PROVISION_ID, provisionInventoryItem.getProvisionId()), QueryColumn.column(COLUMN_PLAYER_ID, provisionInventoryItem.getPlayerId()), QueryColumn.column(COLUMN_ACQUIRE_TIME, provisionInventoryItem.getAcquireTime()), QueryColumn.column(COLUMN_START_EXPIRY_TIME, provisionInventoryItem.getStartExpiryTime()), QueryColumn.column(COLUMN_END_EXPIRY_TIME, provisionInventoryItem.getEndExpiryTime()), QueryColumn.column(COLUMN_UNITS_REMAINING, provisionInventoryItem.getUnitsRemaining()), QueryColumn.column(COLUMN_SPOILED, provisionInventoryItem.isSpoiled())).execute();
    }

    @Override
    public List<ProvisionInventoryItem> retrieveAll() {
        return Query.selectAllFrom("PROVISION_INVENTORY_ITEM").getList(this::getFromResultRow);
    }

    private ProvisionInventoryItem getFromResultRow(ResultRow row) {
        UUID uuid = row.getUuid(COLUMN_UUID);
        int provisionId = row.getInt(COLUMN_PROVISION_ID);
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        long acquireTime = row.getLong(COLUMN_ACQUIRE_TIME);
        Long startExpiryTime = row.getNullableLong(COLUMN_START_EXPIRY_TIME);
        Long endExpiryTime = row.getNullableLong(COLUMN_END_EXPIRY_TIME);
        double unitsRemaining = row.getDouble(COLUMN_UNITS_REMAINING);
        boolean spoiled = row.getBoolean(COLUMN_SPOILED);
        return new ProvisionInventoryItem(uuid, provisionId, playerId, acquireTime, startExpiryTime, endExpiryTime, unitsRemaining, spoiled);
    }

    @Override
    public void update(ProvisionInventoryItem provisionInventoryItem) {
        Query.update("PROVISION_INVENTORY_ITEM").set(QueryColumn.column(COLUMN_UNITS_REMAINING, provisionInventoryItem.getUnitsRemaining())).where(QueryColumn.column(COLUMN_UUID, provisionInventoryItem.getUuid())).execute();
    }

    @Override
    public void deleteByKey(UUID uuid) {
        Query.deleteFrom("PROVISION_INVENTORY_ITEM").where(QueryColumn.column(COLUMN_UUID, uuid)).execute();
    }
}

