/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.provision;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.provision.PlayerProvisionItemInfo;
import com.equestricraft.core.player.provision.ProvisionInventoryItem;
import com.equestricraft.core.player.provision.ProvisionInventoryItemEntry;
import com.equestricraft.core.player.provision.ProvisionInventoryItemRepository;
import com.equestricraft.core.player.provision.ProvisionInventoryItemSession;
import com.equestricraft.core.player.provision.ProvisionTypeInventoryDetails;
import com.equestricraft.core.provision.Provision;
import com.equestricraft.core.provision.ProvisionInfo;
import com.equestricraft.core.provision.ProvisionRepository;
import com.equestricraft.core.provision.ProvisionTransformer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class ProvisionInventoryItemSessionImpl
implements ProvisionInventoryItemSession {
    @Service
    private ProvisionInventoryItemRepository provisionInventoryItemRepository;
    @Service
    private ProvisionRepository provisionRepository;
    @Service
    private ProvisionTransformer provisionTransformer;

    @Override
    public List<UUID> addItemToInventory(ECPlayer player, Provision provision, int quantity) {
        ExpiryInformation expiry = this.calculateExpiry(provision);
        if (provision.isDivisible()) {
            ProvisionInventoryItem item = this.createItem(player, provision, quantity, expiry);
            this.provisionInventoryItemRepository.add(item);
            return Collections.singletonList(item.getUuid());
        }
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (int i = 0; i < quantity; ++i) {
            ProvisionInventoryItem item = this.createItem(player, provision, 1, expiry);
            this.provisionInventoryItemRepository.add(item);
            uuids.add(item.getUuid());
        }
        return uuids;
    }

    @Override
    public void removeItemFromInventory(UUID key, double quantity) {
        ProvisionInventoryItem item = (ProvisionInventoryItem)this.provisionInventoryItemRepository.findByKey(key);
        double newUnits = item.getUnitsRemaining() - quantity;
        item.setUnitsRemaining(newUnits);
        item.save();
        if (newUnits <= 0.0) {
            this.provisionInventoryItemRepository.removeByKey(key);
        }
    }

    @Override
    public List<ProvisionInventoryItemEntry> retrievePlayersInventory(ECPlayer player) {
        List<ProvisionInventoryItem> playersItems = this.provisionInventoryItemRepository.findInventoryItemsByPlayer(player.getId());
        List<Integer> provisionIds = playersItems.stream().map(ProvisionInventoryItem::getProvisionId).distinct().toList();
        List provisions = this.provisionRepository.findByKeys(provisionIds);
        return playersItems.stream().map(item -> {
            Provision provision = provisions.stream().filter(p -> p.getId() == item.getProvisionId()).findFirst().orElseThrow();
            return new ProvisionInventoryItemEntry(provision, item.getUnitsRemaining(), item.getUuid(), new Date(item.getAcquireTime()), new Date(item.getStartExpiryTime()), new Date(item.getEndExpiryTime()), item.getUnitsRemaining(), item.isSpoiled());
        }).toList();
    }

    @Override
    public List<ProvisionTypeInventoryDetails> retrieveListOfProvisionItemsPlayerHas(ECPlayer player) {
        Map<Provision, List<PlayerProvisionItemInfo>> playersItems = this.retrievePlayersRemainingInventoryItems(player);
        return this.toTypeInventoryDetails(playersItems);
    }

    private Map<Provision, List<PlayerProvisionItemInfo>> retrievePlayersRemainingInventoryItems(ECPlayer player) {
        List<ProvisionInventoryItem> items = this.provisionInventoryItemRepository.findInventoryItemsByPlayer(player.getId());
        return items.stream().map(this::buildItemInfo).collect(Collectors.groupingBy(i -> (Provision)this.provisionRepository.findByKey(i.provisionId())));
    }

    private List<ProvisionTypeInventoryDetails> toTypeInventoryDetails(Map<Provision, List<PlayerProvisionItemInfo>> items) {
        ArrayList<ProvisionTypeInventoryDetails> details = new ArrayList<ProvisionTypeInventoryDetails>(items.size());
        for (Map.Entry<Provision, List<PlayerProvisionItemInfo>> entry : items.entrySet()) {
            ProvisionInfo provisionInfo = this.provisionTransformer.toInfo(entry.getKey());
            double quantity = entry.getValue().stream().mapToDouble(PlayerProvisionItemInfo::unitsRemaining).sum();
            double expiredQuantity = entry.getValue().stream().filter(i -> i.daysUntilExpiry() <= 0).mapToDouble(PlayerProvisionItemInfo::unitsRemaining).sum();
            ProvisionTypeInventoryDetails detail = new ProvisionTypeInventoryDetails(provisionInfo, quantity, expiredQuantity);
            details.add(detail);
        }
        return details;
    }

    private ExpiryInformation calculateExpiry(Provision provision) {
        if (this.hasExpiry(provision)) {
            long expiryStart = DateUtils.futureDaysOffset(provision.getExpiryStartDays()).getTime();
            long expiryEnd = DateUtils.futureDaysOffset(provision.getExpiryEndDays()).getTime();
            return new ExpiryInformation(expiryStart, expiryEnd);
        }
        return new ExpiryInformation(null, null);
    }

    private boolean hasExpiry(Provision provision) {
        return provision.getExpiryStartDays() != null && provision.getExpiryEndDays() != null;
    }

    private ProvisionInventoryItem createItem(ECPlayer player, Provision provision, int units, ExpiryInformation expiryInformation) {
        boolean shouldSpoil = this.isShouldSpoil(provision);
        return new ProvisionInventoryItem(UUID.randomUUID(), provision.getId(), player.getId(), System.currentTimeMillis(), expiryInformation.start(), expiryInformation.end(), units, shouldSpoil);
    }

    private boolean isShouldSpoil(Provision provision) {
        if (provision.getSpoilChance() <= 0.0) {
            return false;
        }
        return (double)NumberUtils.randomIntInRange(1, 100) <= provision.getSpoilChance();
    }

    @Override
    public List<PlayerProvisionItemInfo> retrievePlayersRemainingInventoryItems(ECPlayer player, int provisionId) {
        List<ProvisionInventoryItem> items = this.provisionInventoryItemRepository.findInventoryItemsByPlayerAndItem(player.getId(), provisionId);
        return items.stream().map(this::buildItemInfo).toList();
    }

    private PlayerProvisionItemInfo buildItemInfo(ProvisionInventoryItem provisionItem) {
        Provision provision = (Provision)this.provisionRepository.findByKey(provisionItem.getProvisionId());
        Integer daysUntilExpiry = this.calculateDaysUntilExpiry(provisionItem);
        return new PlayerProvisionItemInfo(provisionItem.getUuid(), provisionItem.getProvisionId(), provision.getName(), provision.getDescription(), daysUntilExpiry, provisionItem.getUnitsRemaining());
    }

    private Integer calculateDaysUntilExpiry(ProvisionInventoryItem provisionItem) {
        if (provisionItem.getStartExpiryTime() != null) {
            return DateUtils.daysUntil(provisionItem.getStartExpiryTime());
        }
        return null;
    }

    private record ExpiryInformation(Long start, Long end) {
        ExpiryInformation {
            if (start != null && end != null && start > end) {
                throw new IllegalArgumentException("Invalid provision expiry configuration. This could indicate a configuration issue");
            }
        }
    }
}

