/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.quest;

import com.equestricraft.api.common.APIPlayerQuestDto;
import com.equestricraft.api.common.APIResponse;
import com.equestricraft.core.player.quest.PlayerQuestAccessor;
import com.equestricraft.core.quest.CannotStartQuestException;
import com.equestricraft.core.quest.Quest;

public class APIPlayerQuestDtoImpl
implements APIPlayerQuestDto {
    private final Quest quest;
    private final PlayerQuestAccessor playerQuestAccessor;

    public APIPlayerQuestDtoImpl(Quest quest, PlayerQuestAccessor playerQuestAccessor) {
        this.quest = quest;
        this.playerQuestAccessor = playerQuestAccessor;
    }

    @Override
    public APIResponse start(String startElementKey) {
        try {
            this.playerQuestAccessor.startQuest(this.quest, startElementKey);
            return APIResponse.success();
        }
        catch (CannotStartQuestException ex) {
            return APIResponse.fail(ex.getMessage());
        }
    }

    @Override
    public boolean isPlayed() {
        return this.playerQuestAccessor.hasPlayedQuest(this.quest);
    }
}

