/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.quest;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.AbstractPlayerAccessor;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.quest.CannotStartQuestException;
import com.equestricraft.core.quest.Quest;
import com.equestricraft.core.quest.QuestStartSession;
import com.equestricraft.core.quest.element.QuestElement;
import com.equestricraft.core.quest.element.QuestStartElement;
import com.equestricraft.core.quest.log.QuestLogSession;
import com.equestricraft.core.quest.questplayer.QuestPlayer;

public class PlayerQuestAccessor
extends AbstractPlayerAccessor {
    @Service
    private static QuestStartSession questStartSession;
    @Service
    private static QuestLogSession questLogSession;

    public PlayerQuestAccessor(CorePlayer player) {
        super(player);
    }

    public void startQuest(Quest quest, String startElementKey) throws CannotStartQuestException {
        QuestPlayer questPlayer = this.player.require(QuestPlayer.class);
        QuestElement element = quest.getElementByNameKey(startElementKey);
        if (!(element instanceof QuestStartElement)) {
            throw new IllegalArgumentException(String.format("Element %s is not a starting element", startElementKey));
        }
        QuestStartElement startElement = (QuestStartElement)element;
        questStartSession.startQuest(questPlayer, quest, startElement);
    }

    public boolean hasPlayedQuest(Quest quest) {
        return questLogSession.hasPlayerCompletedQuest(this.player, quest.getId());
    }
}

