/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.ride;

import com.equestricraft.api.common.APIPlayerRideTimeConfigDetails;
import com.equestricraft.api.common.APIPlayerRideTimeDto;
import com.equestricraft.api.common.APIPlayerRideTimeValueDto;
import com.equestricraft.common.Range;
import com.equestricraft.core.player.ride.APIPlayerRideTimeValueDtoImpl;
import com.equestricraft.core.player.ride.PlayerRideTimeAccessor;
import groovy.lang.Closure;
import java.time.Duration;
import java.util.Date;

public class APIPlayerRideTimeDtoImpl
implements APIPlayerRideTimeDto {
    private final PlayerRideTimeAccessor playerRideTimeAccessor;

    public APIPlayerRideTimeDtoImpl(PlayerRideTimeAccessor playerRideTimeAccessor) {
        this.playerRideTimeAccessor = playerRideTimeAccessor;
    }

    @Override
    public APIPlayerRideTimeValueDto getTotal() {
        Duration duration = this.playerRideTimeAccessor.getTotalRideTime();
        return new APIPlayerRideTimeValueDtoImpl(duration);
    }

    @Override
    public APIPlayerRideTimeValueDto getTotal(Closure<?> config) {
        APIPlayerRideTimeConfigDetails configDetails = this.getConfigDetails(config);
        Duration duration = this.playerRideTimeAccessor.getTotalRideTime(Range.of(configDetails.getStartTime(), configDetails.getEndTime()));
        return new APIPlayerRideTimeValueDtoImpl(duration);
    }

    @Override
    public APIPlayerRideTimeValueDto getTotal(Date startTime, Date endTime) {
        Duration duration = this.playerRideTimeAccessor.getTotalRideTime(Range.of(startTime, endTime));
        return new APIPlayerRideTimeValueDtoImpl(duration);
    }

    private APIPlayerRideTimeConfigDetails getConfigDetails(Closure<?> config) {
        APIPlayerRideTimeConfigDetails configDetails = new APIPlayerRideTimeConfigDetails();
        config.setDelegate(configDetails);
        config.call();
        return configDetails;
    }
}

