/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.settings;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.player.settings.PlayerSettingsRepository;
import java.util.Objects;

public class PlayerSettings
implements RepositoryEntity<Integer> {
    private final int playerId;
    private boolean hideChatDuringQuests;
    private boolean showPlotMinimap;

    public PlayerSettings(int playerId, boolean hideChatDuringQuests, boolean showPlotMinimap) {
        this.playerId = playerId;
        this.hideChatDuringQuests = hideChatDuringQuests;
        this.showPlotMinimap = showPlotMinimap;
    }

    @Override
    public Integer getKey() {
        return this.getPlayerId();
    }

    public int getPlayerId() {
        return this.playerId;
    }

    public boolean isHideChatDuringQuests() {
        return this.hideChatDuringQuests;
    }

    public void setHideChatDuringQuests(boolean hideChatDuringQuests) {
        this.hideChatDuringQuests = hideChatDuringQuests;
    }

    public boolean isShowPlotMinimap() {
        return this.showPlotMinimap;
    }

    public void setShowPlotMinimap(boolean showPlotMinimap) {
        this.showPlotMinimap = showPlotMinimap;
    }

    @Override
    public void save() {
        Services.getService(PlayerSettingsRepository.class).update(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerSettings that = (PlayerSettings)o;
        return this.playerId == that.playerId;
    }

    public int hashCode() {
        return Objects.hash(this.playerId);
    }
}

