/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.settings;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.player.settings.PlayerSettings;
import java.util.List;

public class PlayerSettingsDatabase
implements RepositoryDatasource<PlayerSettings, Integer> {
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_HIDE_CHAT_DURING_QUESTS = "HIDE_CHAT_DURING_QUESTS";
    private static final String COLUMN_SHOW_PLOT_MINIMAP = "SHOW_PLOT_MINIMAP";

    @Override
    public void create(PlayerSettings playerSettings) {
        Query.insertInto("PLAYER_SETTINGS").columns(QueryColumn.column(COLUMN_PLAYER_ID, playerSettings.getPlayerId()), QueryColumn.column(COLUMN_HIDE_CHAT_DURING_QUESTS, playerSettings.isHideChatDuringQuests()), QueryColumn.column(COLUMN_SHOW_PLOT_MINIMAP, playerSettings.isShowPlotMinimap())).execute();
    }

    @Override
    public List<PlayerSettings> retrieveAll() {
        return Query.selectAllFrom("PLAYER_SETTINGS").getList(this::getFromResultRow);
    }

    private PlayerSettings getFromResultRow(ResultRow resultRow) {
        int playerId = resultRow.getInt(COLUMN_PLAYER_ID);
        boolean hideChatDuringQuests = resultRow.getBoolean(COLUMN_HIDE_CHAT_DURING_QUESTS);
        boolean showPlotMinimap = resultRow.getBoolean(COLUMN_SHOW_PLOT_MINIMAP);
        return new PlayerSettings(playerId, hideChatDuringQuests, showPlotMinimap);
    }

    @Override
    public void update(PlayerSettings playerSettings) {
        Query.update("PLAYER_SETTINGS").set(QueryColumn.column(COLUMN_HIDE_CHAT_DURING_QUESTS, playerSettings.isHideChatDuringQuests())).set(QueryColumn.column(COLUMN_SHOW_PLOT_MINIMAP, playerSettings.isShowPlotMinimap())).where(QueryColumn.column(COLUMN_PLAYER_ID, playerSettings.getPlayerId())).execute();
    }
}

