/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.settings;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.NewPlayerSettings;
import com.equestricraft.core.player.settings.PlayerSettings;
import com.equestricraft.core.player.settings.PlayerSettingsDto;
import com.equestricraft.core.player.settings.PlayerSettingsRepository;
import com.equestricraft.core.player.settings.PlayerSettingsSession;

public class PlayerSettingsSessionImpl
implements PlayerSettingsSession {
    @Service
    private PlayerSettingsRepository playerSettingsRepository;

    @Override
    public void initialiseSettingsForPlayer(ECPlayer player) {
        PlayerSettings playerSettings = new PlayerSettings(player.getId(), NewPlayerSettings.getChatDisabledInQuests(), true);
        this.playerSettingsRepository.add(playerSettings);
    }

    @Override
    public PlayerSettingsDto getSettingsForPlayer(ECPlayer player) {
        PlayerSettings settings = (PlayerSettings)this.playerSettingsRepository.findByKey(player.getId());
        return new PlayerSettingsDto(settings.isHideChatDuringQuests(), settings.isShowPlotMinimap());
    }

    @Override
    public void updateHideChatDuringQuests(ECPlayer player, boolean value) {
        PlayerSettings settings = (PlayerSettings)this.playerSettingsRepository.findByKey(player.getId());
        settings.setHideChatDuringQuests(value);
        settings.save();
    }

    @Override
    public void updateShowPlotMinimap(ECPlayer player, boolean value) {
        PlayerSettings settings = (PlayerSettings)this.playerSettingsRepository.findByKey(player.getId());
        settings.setShowPlotMinimap(value);
    }
}

