/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.shop;

import com.equestricraft.api.common.APIDurationDto;
import com.equestricraft.api.common.APIPlayerShopPurchaseDetailsDto;
import com.equestricraft.api.common.APIPlayerShopQuantitySearchDto;
import com.equestricraft.api.common.APIPlayerShopsDto;
import com.equestricraft.api.common.APIResponse;
import com.equestricraft.core.player.shop.PlayerShopsAccessor;
import com.equestricraft.core.shop.ShopPurchaseResponse;
import groovy.lang.Closure;
import java.util.Date;

public class APIPlayerShopsDtoImpl
implements APIPlayerShopsDto {
    private final PlayerShopsAccessor playerShopsAccessor;

    public APIPlayerShopsDtoImpl(PlayerShopsAccessor playerShopsAccessor) {
        this.playerShopsAccessor = playerShopsAccessor;
    }

    @Override
    public APIResponse purchase(int shopItemId, int quantity) {
        ShopPurchaseResponse r = this.playerShopsAccessor.purchase(shopItemId, quantity);
        if (r.success()) {
            return APIResponse.success();
        }
        return APIResponse.fail(r.failMessage());
    }

    @Override
    public APIResponse purchase(Closure<?> config) {
        APIPlayerShopPurchaseDetailsDto details = this.getPurchaseDetails(config);
        return this.purchase(details.getShopItemId(), details.getQuantity());
    }

    @Override
    public int getQuantityOfItemBoughtInPastDuration(int shopItemId, APIDurationDto duration) {
        return this.playerShopsAccessor.getQuantityOfItemBoughtInPastDuration(shopItemId, duration.getDuration());
    }

    @Override
    public int getQuantityOfItemBoughtSince(int shopItemId, Date date) {
        return this.playerShopsAccessor.getQuantityOfItemBoughtSince(shopItemId, date);
    }

    @Override
    public int getQuantityOfItemBought(Closure<?> config) {
        APIPlayerShopQuantitySearchDto details = this.getQuantitySearchDetails(config);
        if (details.getDate() != null) {
            return this.getQuantityOfItemBoughtSince(details.getShopItemId(), details.getDate());
        }
        return this.playerShopsAccessor.getQuantityOfItemBoughtInPastDuration(details.getShopItemId(), details.getDuration());
    }

    private APIPlayerShopPurchaseDetailsDto getPurchaseDetails(Closure<?> closure) {
        APIPlayerShopPurchaseDetailsDto purchaseDetails = new APIPlayerShopPurchaseDetailsDto();
        closure.setDelegate(purchaseDetails);
        closure.call();
        return purchaseDetails;
    }

    private APIPlayerShopQuantitySearchDto getQuantitySearchDetails(Closure<?> closure) {
        APIPlayerShopQuantitySearchDto quantitySearchDetails = new APIPlayerShopQuantitySearchDto();
        closure.setDelegate(quantitySearchDetails);
        closure.call();
        return quantitySearchDetails;
    }
}

