/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.tack;

import com.equestricraft.base.pagination.Pagination;
import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.core.item.ECItemRepository;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.tack.TackInventoryItem;
import com.equestricraft.core.player.tack.TackInventoryPage;
import com.equestricraft.core.player.tack.TackInventoryPageItem;
import com.equestricraft.core.player.tack.TackInventoryPageSession;
import com.equestricraft.core.player.tack.bonnet.HorseBonnetInventoryItemRepository;
import com.equestricraft.core.player.tack.boots.HorseBootsInventoryItemRepository;
import com.equestricraft.core.player.tack.bridle.HorseBridleInventoryItemRepository;
import com.equestricraft.core.player.tack.cinch.HorseCinchInventoryItemRepository;
import com.equestricraft.core.player.tack.girth.HorseGirthInventoryItemRepository;
import com.equestricraft.core.player.tack.halter.HorseHalterInventoryItemRepository;
import com.equestricraft.core.player.tack.pad.HorsePadInventoryItemRepository;
import com.equestricraft.core.player.tack.rein.HorseReinInventoryItemRepository;
import com.equestricraft.core.player.tack.saddle.HorseSaddleInventoryItemRepository;
import com.equestricraft.core.player.tack.wraps.HorseWrapsInventoryItemRepository;
import com.equestricraft.core.tack.Tack;
import java.util.Comparator;
import java.util.List;

public class TackInventoryPageSessionImpl
extends Pagination<TackInventoryPageItem, TackInventoryPage, Object, Object>
implements TackInventoryPageSession {
    @Service
    private HorseBonnetInventoryItemRepository horseBonnetInventoryItemRepository;
    @Service
    private HorseBootsInventoryItemRepository horseBootsInventoryItemRepository;
    @Service
    private HorseBridleInventoryItemRepository horseBridleInventoryItemRepository;
    @Service
    private HorseCinchInventoryItemRepository horseCinchInventoryItemRepository;
    @Service
    private HorseGirthInventoryItemRepository horseGirthInventoryItemRepository;
    @Service
    private HorseHalterInventoryItemRepository horseHalterInventoryItemRepository;
    @Service
    private HorsePadInventoryItemRepository horsePadInventoryItemRepository;
    @Service
    private HorseReinInventoryItemRepository horseReinInventoryItemRepository;
    @Service
    private HorseSaddleInventoryItemRepository horseSaddleInventoryItemRepository;
    @Service
    private HorseWrapsInventoryItemRepository horseWrapsInventoryItemRepository;
    @Service
    private ECItemRepository ecItemRepository;

    @Override
    public TackInventoryPage retrievePage(ECPlayer player, int pageNumber) {
        List<TackInventoryItem> tack = this.getAllInventoryItems(player);
        List<TackInventoryPageItem> items = tack.stream().map(this::buildPageItem).toList();
        return (TackInventoryPage)this.paginate(items, pageNumber, SortDirection.ASCENDING, null, null);
    }

    private List<TackInventoryItem> getAllInventoryItems(ECPlayer player) {
        return ListUtils.concat(this.horseBonnetInventoryItemRepository.findInventoryItemsByPlayer(player.getId()), this.horseBootsInventoryItemRepository.findInventoryItemsByPlayer(player.getId()), this.horseBridleInventoryItemRepository.findInventoryItemsByPlayer(player.getId()), this.horseCinchInventoryItemRepository.findInventoryItemsByPlayer(player.getId()), this.horseGirthInventoryItemRepository.findInventoryItemsByPlayer(player.getId()), this.horseHalterInventoryItemRepository.findInventoryItemsByPlayer(player.getId()), this.horsePadInventoryItemRepository.findInventoryItemsByPlayer(player.getId()), this.horseReinInventoryItemRepository.findInventoryItemsByPlayer(player.getId()), this.horseSaddleInventoryItemRepository.findInventoryItemsByPlayer(player.getId()), this.horseWrapsInventoryItemRepository.findInventoryItemsByPlayer(player.getId()));
    }

    private TackInventoryPageItem buildPageItem(TackInventoryItem tackInventoryItem) {
        Tack tack = (Tack)this.ecItemRepository.findByKey(tackInventoryItem.getTackId());
        double wearPercentage = tack.getWearDurationHours() == 0 ? 0.0 : (double)tackInventoryItem.getTotalWearDuration() / (double)((long)tack.getWearDurationHours() * 3600000L) * 100.0;
        return new TackInventoryPageItem(tackInventoryItem.getUuid(), tackInventoryItem.getTackId(), tack.getName(), 100.0 - wearPercentage);
    }

    @Override
    protected int getMaximumPerPage() {
        return 10;
    }

    @Override
    protected boolean filter(TackInventoryPageItem item, Object filterObject) {
        return true;
    }

    @Override
    protected Comparator<TackInventoryPageItem> compare(Object sortOrderObject) {
        return Comparator.comparing(TackInventoryPageItem::name);
    }

    @Override
    protected TackInventoryPage buildPage(List<TackInventoryPageItem> items, int pageNumber, int totalPages, SortDirection sortDirection, Object sortObject, Object filterObject) {
        return new TackInventoryPage(items, pageNumber, totalPages, sortDirection, sortObject, filterObject);
    }
}

