/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.tack;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.tack.TackType;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.tack.TackInventoryItem;
import com.equestricraft.core.player.tack.TackInventoryItemInfo;
import com.equestricraft.core.player.tack.TackInventoryItemRepository;
import com.equestricraft.core.player.tack.TackInventorySession;
import com.equestricraft.core.player.tack.bonnet.HorseBonnetInventoryItem;
import com.equestricraft.core.player.tack.bonnet.HorseBonnetInventoryItemRepository;
import com.equestricraft.core.player.tack.bonnet.HorseBonnetInventorySession;
import com.equestricraft.core.player.tack.boots.HorseBootsInventoryItem;
import com.equestricraft.core.player.tack.boots.HorseBootsInventoryItemRepository;
import com.equestricraft.core.player.tack.boots.HorseBootsInventorySession;
import com.equestricraft.core.player.tack.bridle.HorseBridleInventoryItem;
import com.equestricraft.core.player.tack.bridle.HorseBridleInventoryItemRepository;
import com.equestricraft.core.player.tack.bridle.HorseBridleInventorySession;
import com.equestricraft.core.player.tack.cinch.HorseCinchInventoryItem;
import com.equestricraft.core.player.tack.cinch.HorseCinchInventoryItemRepository;
import com.equestricraft.core.player.tack.cinch.HorseCinchInventorySession;
import com.equestricraft.core.player.tack.girth.HorseGirthInventoryItem;
import com.equestricraft.core.player.tack.girth.HorseGirthInventoryItemRepository;
import com.equestricraft.core.player.tack.girth.HorseGirthInventorySession;
import com.equestricraft.core.player.tack.halter.HorseHalterInventoryItem;
import com.equestricraft.core.player.tack.halter.HorseHalterInventoryItemRepository;
import com.equestricraft.core.player.tack.halter.HorseHalterInventorySession;
import com.equestricraft.core.player.tack.pad.HorsePadInventoryItem;
import com.equestricraft.core.player.tack.pad.HorsePadInventoryItemRepository;
import com.equestricraft.core.player.tack.pad.HorsePadInventorySession;
import com.equestricraft.core.player.tack.rein.HorseReinInventoryItem;
import com.equestricraft.core.player.tack.rein.HorseReinInventoryItemRepository;
import com.equestricraft.core.player.tack.rein.HorseReinInventorySession;
import com.equestricraft.core.player.tack.saddle.HorseSaddleInventoryItem;
import com.equestricraft.core.player.tack.saddle.HorseSaddleInventoryItemRepository;
import com.equestricraft.core.player.tack.saddle.HorseSaddleInventorySession;
import com.equestricraft.core.player.tack.wraps.HorseWrapsInventoryItem;
import com.equestricraft.core.player.tack.wraps.HorseWrapsInventoryItemRepository;
import com.equestricraft.core.player.tack.wraps.HorseWrapsInventorySession;
import com.equestricraft.core.tack.Tack;
import com.equestricraft.core.tack.TackSession;
import com.equestricraft.core.tack.bonnet.HorseBonnet;
import com.equestricraft.core.tack.boots.HorseBoots;
import com.equestricraft.core.tack.bridle.HorseBridle;
import com.equestricraft.core.tack.cinch.HorseCinch;
import com.equestricraft.core.tack.girth.HorseGirth;
import com.equestricraft.core.tack.halter.HorseHalter;
import com.equestricraft.core.tack.pad.HorsePad;
import com.equestricraft.core.tack.rein.HorseRein;
import com.equestricraft.core.tack.saddle.HorseSaddle;
import com.equestricraft.core.tack.wraps.HorseWraps;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class TackInventorySessionImpl
implements TackInventorySession {
    @Service
    private HorseBonnetInventoryItemRepository horseBonnetInventoryItemRepository;
    @Service
    private HorseBootsInventoryItemRepository horseBootsInventoryItemRepository;
    @Service
    private HorseBridleInventoryItemRepository horseBridleInventoryItemRepository;
    @Service
    private HorseCinchInventoryItemRepository horseCinchInventoryItemRepository;
    @Service
    private HorseGirthInventoryItemRepository horseGirthInventoryItemRepository;
    @Service
    private HorseHalterInventoryItemRepository horseHalterInventoryItemRepository;
    @Service
    private HorsePadInventoryItemRepository horsePadInventoryItemRepository;
    @Service
    private HorseReinInventoryItemRepository horseReinInventoryItemRepository;
    @Service
    private HorseSaddleInventoryItemRepository horseSaddleInventoryItemRepository;
    @Service
    private HorseWrapsInventoryItemRepository horseWrapsInventoryItemRepository;
    @Service
    private HorseBonnetInventorySession horseBonnetInventorySession;
    @Service
    private HorseBootsInventorySession horseBootsInventorySession;
    @Service
    private HorseBridleInventorySession horseBridleInventorySession;
    @Service
    private HorseCinchInventorySession horseCinchInventorySession;
    @Service
    private HorseGirthInventorySession horseGirthInventorySession;
    @Service
    private HorseHalterInventorySession horseHalterInventorySession;
    @Service
    private HorsePadInventorySession horsePadInventorySession;
    @Service
    private HorseReinInventorySession horseReinInventorySession;
    @Service
    private HorseSaddleInventorySession horseSaddleInventorySession;
    @Service
    private HorseWrapsInventorySession horseWrapsInventorySession;
    @Service
    private TackSession tackSession;

    @Override
    public TackInventoryItem addItemToInventory(ECPlayer player, TackType tackType, int tackId) {
        Tack tack = this.tackSession.getTack(tackType, tackId);
        if (tack instanceof HorseBonnet) {
            HorseBonnet bonnet = (HorseBonnet)tack;
            return this.horseBonnetInventorySession.addItemToInventory(player, bonnet);
        }
        if (tack instanceof HorseBoots) {
            HorseBoots boots = (HorseBoots)tack;
            return this.horseBootsInventorySession.addItemToInventory(player, boots);
        }
        if (tack instanceof HorseBridle) {
            HorseBridle bridle = (HorseBridle)tack;
            return this.horseBridleInventorySession.addItemToInventory(player, bridle);
        }
        if (tack instanceof HorseCinch) {
            HorseCinch cinch = (HorseCinch)tack;
            return this.horseCinchInventorySession.addItemToInventory(player, cinch);
        }
        if (tack instanceof HorseGirth) {
            HorseGirth girth = (HorseGirth)tack;
            return this.horseGirthInventorySession.addItemToInventory(player, girth);
        }
        if (tack instanceof HorseHalter) {
            HorseHalter halter = (HorseHalter)tack;
            return this.horseHalterInventorySession.addItemToInventory(player, halter);
        }
        if (tack instanceof HorsePad) {
            HorsePad pad = (HorsePad)tack;
            return this.horsePadInventorySession.addItemToInventory(player, pad);
        }
        if (tack instanceof HorseRein) {
            HorseRein rein = (HorseRein)tack;
            return this.horseReinInventorySession.addItemToInventory(player, rein);
        }
        if (tack instanceof HorseSaddle) {
            HorseSaddle saddle = (HorseSaddle)tack;
            return this.horseSaddleInventorySession.addItemToInventory(player, saddle);
        }
        if (tack instanceof HorseWraps) {
            HorseWraps wraps = (HorseWraps)tack;
            return this.horseWrapsInventorySession.addItemToInventory(player, wraps);
        }
        throw new IllegalArgumentException(String.format("Invalid tack type: %s", tackType.name()));
    }

    @Override
    public TackInventoryItemInfo getInventoryItem(UUID uuid) {
        TackInventoryItem item = this.findInventoryItem(uuid).orElseThrow();
        Tack tack = this.getTack(item);
        return new TackInventoryItemInfo(tack, item);
    }

    private Tack getTack(TackInventoryItem item) {
        if (item instanceof HorseBonnetInventoryItem) {
            return this.tackSession.getBonnet(item.getTackId());
        }
        if (item instanceof HorseBootsInventoryItem) {
            return this.tackSession.getBoots(item.getTackId());
        }
        if (item instanceof HorseBridleInventoryItem) {
            return this.tackSession.getBridle(item.getTackId());
        }
        if (item instanceof HorseCinchInventoryItem) {
            return this.tackSession.getCinch(item.getTackId());
        }
        if (item instanceof HorseGirthInventoryItem) {
            return this.tackSession.getGirth(item.getTackId());
        }
        if (item instanceof HorseHalterInventoryItem) {
            return this.tackSession.getHalter(item.getTackId());
        }
        if (item instanceof HorsePadInventoryItem) {
            return this.tackSession.getPad(item.getTackId());
        }
        if (item instanceof HorseReinInventoryItem) {
            return this.tackSession.getRein(item.getTackId());
        }
        if (item instanceof HorseSaddleInventoryItem) {
            return this.tackSession.getSaddle(item.getTackId());
        }
        if (item instanceof HorseWrapsInventoryItem) {
            return this.tackSession.getWraps(item.getTackId());
        }
        throw new IllegalArgumentException(String.format("Invalid item: %s", item.getClass().getName()));
    }

    @Override
    public Optional<TackInventoryItem> findInventoryItem(UUID uuid) {
        List<HorseWrapsInventoryItemRepository> repos = List.of(this.horseBonnetInventoryItemRepository, this.horseBootsInventoryItemRepository, this.horseBridleInventoryItemRepository, this.horseCinchInventoryItemRepository, this.horseGirthInventoryItemRepository, this.horseHalterInventoryItemRepository, this.horsePadInventoryItemRepository, this.horseReinInventoryItemRepository, this.horseSaddleInventoryItemRepository, this.horseWrapsInventoryItemRepository);
        for (TackInventoryItemRepository tackInventoryItemRepository : repos) {
            Optional item = tackInventoryItemRepository.findByKeyIfExists(uuid);
            if (!item.isPresent()) continue;
            return Optional.of((TackInventoryItem)item.get());
        }
        return Optional.empty();
    }
}

