/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.tack.bonnet;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.core.player.tack.TackInventoryItemDatabase;
import com.equestricraft.core.player.tack.bonnet.HorseBonnetInventoryItem;
import java.util.UUID;

public class HorseBonnetInventoryItemDatabase
extends TackInventoryItemDatabase<HorseBonnetInventoryItem> {
    @Override
    public String getTableName() {
        return "HORSE_BONNET_INVENTORY_ITEM";
    }

    @Override
    public void create(HorseBonnetInventoryItem horseBonnetInventoryItem) {
        Query.insertInto(this.getTableName()).columns(QueryColumn.column("UUID", horseBonnetInventoryItem.getUuid()), QueryColumn.column("PLAYER_ID", horseBonnetInventoryItem.getPlayerId()), QueryColumn.column("TACK_ID", horseBonnetInventoryItem.getTackId()), QueryColumn.column("TOTAL_WEAR_DURATION", horseBonnetInventoryItem.getTotalWearDuration()), QueryColumn.column("FIT_QUALITY", horseBonnetInventoryItem.getFitQuality())).execute();
    }

    @Override
    public HorseBonnetInventoryItem getFromResultRow(ResultRow row) {
        UUID uuid = row.getUuid("UUID");
        int playerId = row.getInt("PLAYER_ID");
        int tackId = row.getInt("TACK_ID");
        long totalWearDuration = row.getLong("TOTAL_WEAR_DURATION");
        double fitQuality = row.getDouble("FIT_QUALITY");
        return new HorseBonnetInventoryItem(uuid, playerId, tackId, totalWearDuration, fitQuality);
    }

    @Override
    public void update(HorseBonnetInventoryItem horseBonnetInventoryItem) {
        Query.update(this.getTableName()).set(QueryColumn.column("TOTAL_WEAR_DURATION", horseBonnetInventoryItem.getTotalWearDuration()), QueryColumn.column("FIT_QUALITY", horseBonnetInventoryItem.getFitQuality())).where(QueryColumn.column("UUID", horseBonnetInventoryItem.getUuid())).execute();
    }
}

