/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.tack.boots;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.core.player.tack.TackInventoryItemDatabase;
import com.equestricraft.core.player.tack.boots.HorseBootsInventoryItem;
import java.util.UUID;

public class HorseBootsInventoryItemDatabase
extends TackInventoryItemDatabase<HorseBootsInventoryItem> {
    @Override
    public String getTableName() {
        return "HORSE_BOOTS_INVENTORY_ITEM";
    }

    @Override
    public void create(HorseBootsInventoryItem horseBootsInventoryItem) {
        Query.insertInto(this.getTableName()).columns(QueryColumn.column("UUID", horseBootsInventoryItem.getUuid()), QueryColumn.column("PLAYER_ID", horseBootsInventoryItem.getPlayerId()), QueryColumn.column("TACK_ID", horseBootsInventoryItem.getTackId()), QueryColumn.column("TOTAL_WEAR_DURATION", horseBootsInventoryItem.getTotalWearDuration()), QueryColumn.column("FIT_QUALITY", horseBootsInventoryItem.getFitQuality())).execute();
    }

    @Override
    public HorseBootsInventoryItem getFromResultRow(ResultRow row) {
        UUID uuid = row.getUuid("UUID");
        int playerId = row.getInt("PLAYER_ID");
        int tackId = row.getInt("TACK_ID");
        long totalWearDuration = row.getLong("TOTAL_WEAR_DURATION");
        double fitQuality = row.getDouble("FIT_QUALITY");
        return new HorseBootsInventoryItem(uuid, playerId, tackId, totalWearDuration, fitQuality);
    }

    @Override
    public void update(HorseBootsInventoryItem horseBootsInventoryItem) {
        Query.update(this.getTableName()).set(QueryColumn.column("TOTAL_WEAR_DURATION", horseBootsInventoryItem.getTotalWearDuration()), QueryColumn.column("FIT_QUALITY", horseBootsInventoryItem.getFitQuality())).where(QueryColumn.column("UUID", horseBootsInventoryItem.getUuid())).execute();
    }
}

