/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.tack.boots;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.tack.HorseTackInfo;
import com.equestricraft.core.player.tack.boots.HorseBootsInventoryItem;
import com.equestricraft.core.player.tack.boots.HorseBootsInventoryItemRepository;
import com.equestricraft.core.player.tack.boots.HorseBootsInventorySession;
import com.equestricraft.core.tack.boots.HorseBoots;
import com.equestricraft.core.tack.boots.HorseBootsRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class HorseBootsInventorySessionImpl
implements HorseBootsInventorySession {
    @Service
    private HorseBootsRepository horseBootsRepository;
    @Service
    private HorseBootsInventoryItemRepository horseBootsInventoryItemRepository;

    @Override
    public HorseBootsInventoryItem addItemToInventory(ECPlayer player, HorseBoots tack) {
        HorseBootsInventoryItem newItem = new HorseBootsInventoryItem(UUID.randomUUID(), player.getId(), tack.getId(), 0L, 0.0);
        this.horseBootsInventoryItemRepository.add(newItem);
        return newItem;
    }

    @Override
    public List<UUID> addItemToInventory(ECPlayer player, HorseBoots tack, int quantity) {
        ArrayList<UUID> keys2 = new ArrayList<UUID>(quantity);
        for (int i = 0; i < quantity; ++i) {
            HorseBootsInventoryItem item = this.addItemToInventory(player, tack);
            keys2.add(item.getUuid());
        }
        return keys2;
    }

    @Override
    public void removeItemFromInventory(UUID key) {
        this.horseBootsInventoryItemRepository.removeByKey(key);
    }

    @Override
    public HorseTackInfo<HorseBoots, HorseBootsInventoryItem> getBootsForItem(UUID key) {
        HorseBootsInventoryItem item = (HorseBootsInventoryItem)this.horseBootsInventoryItemRepository.findByKey(key);
        HorseBoots tack = (HorseBoots)this.horseBootsRepository.findByKey(item.getTackId());
        return new HorseTackInfo<HorseBoots, HorseBootsInventoryItem>(tack, item);
    }
}

