/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.tack.cinch;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.core.player.tack.TackInventoryItemDatabase;
import com.equestricraft.core.player.tack.cinch.HorseCinchInventoryItem;
import java.util.UUID;

public class HorseCinchInventoryItemDatabase
extends TackInventoryItemDatabase<HorseCinchInventoryItem> {
    @Override
    public String getTableName() {
        return "HORSE_CINCH_INVENTORY_ITEM";
    }

    @Override
    public void create(HorseCinchInventoryItem horseCinchInventoryItem) {
        Query.insertInto(this.getTableName()).columns(QueryColumn.column("UUID", horseCinchInventoryItem.getUuid()), QueryColumn.column("PLAYER_ID", horseCinchInventoryItem.getPlayerId()), QueryColumn.column("TACK_ID", horseCinchInventoryItem.getTackId()), QueryColumn.column("TOTAL_WEAR_DURATION", horseCinchInventoryItem.getTotalWearDuration()), QueryColumn.column("FIT_QUALITY", horseCinchInventoryItem.getFitQuality())).execute();
    }

    @Override
    public HorseCinchInventoryItem getFromResultRow(ResultRow row) {
        UUID uuid = row.getUuid("UUID");
        int playerId = row.getInt("PLAYER_ID");
        int tackId = row.getInt("TACK_ID");
        long totalWearDuration = row.getLong("TOTAL_WEAR_DURATION");
        double fitQuality = row.getDouble("FIT_QUALITY");
        return new HorseCinchInventoryItem(uuid, playerId, tackId, totalWearDuration, fitQuality);
    }

    @Override
    public void update(HorseCinchInventoryItem horseCinchInventoryItem) {
        Query.update(this.getTableName()).set(QueryColumn.column("TOTAL_WEAR_DURATION", horseCinchInventoryItem.getTotalWearDuration()), QueryColumn.column("FIT_QUALITY", horseCinchInventoryItem.getFitQuality())).where(QueryColumn.column("UUID", horseCinchInventoryItem.getUuid())).execute();
    }
}

