/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.tack.girth;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.core.player.tack.TackInventoryItemDatabase;
import com.equestricraft.core.player.tack.girth.HorseGirthInventoryItem;
import java.util.UUID;

public class HorseGirthInventoryItemDatabase
extends TackInventoryItemDatabase<HorseGirthInventoryItem> {
    @Override
    public String getTableName() {
        return "HORSE_GIRTH_INVENTORY_ITEM";
    }

    @Override
    public void create(HorseGirthInventoryItem horseGirthInventoryItem) {
        Query.insertInto(this.getTableName()).columns(QueryColumn.column("UUID", horseGirthInventoryItem.getUuid()), QueryColumn.column("PLAYER_ID", horseGirthInventoryItem.getPlayerId()), QueryColumn.column("TACK_ID", horseGirthInventoryItem.getTackId()), QueryColumn.column("TOTAL_WEAR_DURATION", horseGirthInventoryItem.getTotalWearDuration()), QueryColumn.column("FIT_QUALITY", horseGirthInventoryItem.getFitQuality())).execute();
    }

    @Override
    public HorseGirthInventoryItem getFromResultRow(ResultRow row) {
        UUID uuid = row.getUuid("UUID");
        int playerId = row.getInt("PLAYER_ID");
        int tackId = row.getInt("TACK_ID");
        long totalWearDuration = row.getLong("TOTAL_WEAR_DURATION");
        double fitQuality = row.getDouble("FIT_QUALITY");
        return new HorseGirthInventoryItem(uuid, playerId, tackId, totalWearDuration, fitQuality);
    }

    @Override
    public void update(HorseGirthInventoryItem horseGirthInventoryItem) {
        Query.update(this.getTableName()).set(QueryColumn.column("TOTAL_WEAR_DURATION", horseGirthInventoryItem.getTotalWearDuration()), QueryColumn.column("FIT_QUALITY", horseGirthInventoryItem.getFitQuality())).where(QueryColumn.column("UUID", horseGirthInventoryItem.getUuid())).execute();
    }
}

