/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.tack.girth;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.tack.HorseTackInfo;
import com.equestricraft.core.player.tack.girth.HorseGirthInventoryItem;
import com.equestricraft.core.player.tack.girth.HorseGirthInventoryItemRepository;
import com.equestricraft.core.player.tack.girth.HorseGirthInventorySession;
import com.equestricraft.core.tack.girth.HorseGirth;
import com.equestricraft.core.tack.girth.HorseGirthRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class HorseGirthInventorySessionImpl
implements HorseGirthInventorySession {
    @Service
    private HorseGirthRepository horseGirthRepository;
    @Service
    private HorseGirthInventoryItemRepository horseGirthInventoryItemRepository;

    @Override
    public HorseGirthInventoryItem addItemToInventory(ECPlayer player, HorseGirth tack) {
        HorseGirthInventoryItem newItem = new HorseGirthInventoryItem(UUID.randomUUID(), player.getId(), tack.getId(), 0L, 0.0);
        this.horseGirthInventoryItemRepository.add(newItem);
        return newItem;
    }

    @Override
    public List<UUID> addItemToInventory(ECPlayer player, HorseGirth tack, int quantity) {
        ArrayList<UUID> keys2 = new ArrayList<UUID>(quantity);
        for (int i = 0; i < quantity; ++i) {
            HorseGirthInventoryItem item = this.addItemToInventory(player, tack);
            keys2.add(item.getUuid());
        }
        return keys2;
    }

    @Override
    public void removeItemFromInventory(UUID key) {
        this.horseGirthInventoryItemRepository.removeByKey(key);
    }

    @Override
    public HorseTackInfo<HorseGirth, HorseGirthInventoryItem> getGirthForItem(UUID key) {
        HorseGirthInventoryItem item = (HorseGirthInventoryItem)this.horseGirthInventoryItemRepository.findByKey(key);
        HorseGirth tack = (HorseGirth)this.horseGirthRepository.findByKey(item.getTackId());
        return new HorseTackInfo<HorseGirth, HorseGirthInventoryItem>(tack, item);
    }
}

