/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.tack.halter;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.core.player.tack.TackInventoryItemDatabase;
import com.equestricraft.core.player.tack.halter.HorseHalterInventoryItem;
import java.util.UUID;

public class HorseHalterInventoryItemDatabase
extends TackInventoryItemDatabase<HorseHalterInventoryItem> {
    @Override
    public String getTableName() {
        return "HORSE_HALTER_INVENTORY_ITEM";
    }

    @Override
    public void create(HorseHalterInventoryItem horseHalterInventoryItem) {
        Query.insertInto(this.getTableName()).columns(QueryColumn.column("UUID", horseHalterInventoryItem.getUuid()), QueryColumn.column("PLAYER_ID", horseHalterInventoryItem.getPlayerId()), QueryColumn.column("TACK_ID", horseHalterInventoryItem.getTackId()), QueryColumn.column("TOTAL_WEAR_DURATION", horseHalterInventoryItem.getTotalWearDuration()), QueryColumn.column("FIT_QUALITY", horseHalterInventoryItem.getFitQuality())).execute();
    }

    @Override
    public HorseHalterInventoryItem getFromResultRow(ResultRow row) {
        UUID uuid = row.getUuid("UUID");
        int playerId = row.getInt("PLAYER_ID");
        int tackId = row.getInt("TACK_ID");
        long totalWearDuration = row.getLong("TOTAL_WEAR_DURATION");
        double fitQuality = row.getDouble("FIT_QUALITY");
        return new HorseHalterInventoryItem(uuid, playerId, tackId, totalWearDuration, fitQuality);
    }

    @Override
    public void update(HorseHalterInventoryItem horseHalterInventoryItem) {
        Query.update(this.getTableName()).set(QueryColumn.column("TOTAL_WEAR_DURATION", horseHalterInventoryItem.getTotalWearDuration()), QueryColumn.column("FIT_QUALITY", horseHalterInventoryItem.getFitQuality())).where(QueryColumn.column("UUID", horseHalterInventoryItem.getUuid())).execute();
    }
}

