/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.tack.pad;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.core.player.tack.TackInventoryItemDatabase;
import com.equestricraft.core.player.tack.pad.HorsePadInventoryItem;
import java.util.UUID;

public class HorsePadInventoryItemDatabase
extends TackInventoryItemDatabase<HorsePadInventoryItem> {
    @Override
    public String getTableName() {
        return "HORSE_PAD_INVENTORY_ITEM";
    }

    @Override
    public void create(HorsePadInventoryItem horsePadInventoryItem) {
        Query.insertInto(this.getTableName()).columns(QueryColumn.column("UUID", horsePadInventoryItem.getUuid()), QueryColumn.column("PLAYER_ID", horsePadInventoryItem.getPlayerId()), QueryColumn.column("TACK_ID", horsePadInventoryItem.getTackId()), QueryColumn.column("TOTAL_WEAR_DURATION", horsePadInventoryItem.getTotalWearDuration()), QueryColumn.column("FIT_QUALITY", horsePadInventoryItem.getFitQuality())).execute();
    }

    @Override
    public HorsePadInventoryItem getFromResultRow(ResultRow row) {
        UUID uuid = row.getUuid("UUID");
        int playerId = row.getInt("PLAYER_ID");
        int tackId = row.getInt("TACK_ID");
        long totalWearDuration = row.getLong("TOTAL_WEAR_DURATION");
        double fitQuality = row.getDouble("FIT_QUALITY");
        return new HorsePadInventoryItem(uuid, playerId, tackId, totalWearDuration, fitQuality);
    }

    @Override
    public void update(HorsePadInventoryItem horsePadInventoryItem) {
        Query.update(this.getTableName()).set(QueryColumn.column("TOTAL_WEAR_DURATION", horsePadInventoryItem.getTotalWearDuration()), QueryColumn.column("FIT_QUALITY", horsePadInventoryItem.getFitQuality())).where(QueryColumn.column("UUID", horsePadInventoryItem.getUuid())).execute();
    }
}

