/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.tack.rein;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.core.player.tack.TackInventoryItemDatabase;
import com.equestricraft.core.player.tack.rein.HorseReinInventoryItem;
import java.util.UUID;

public class HorseReinInventoryItemDatabase
extends TackInventoryItemDatabase<HorseReinInventoryItem> {
    @Override
    public String getTableName() {
        return "HORSE_REIN_INVENTORY_ITEM";
    }

    @Override
    public void create(HorseReinInventoryItem horseReinInventoryItem) {
        Query.insertInto(this.getTableName()).columns(QueryColumn.column("UUID", horseReinInventoryItem.getUuid()), QueryColumn.column("PLAYER_ID", horseReinInventoryItem.getPlayerId()), QueryColumn.column("TACK_ID", horseReinInventoryItem.getTackId()), QueryColumn.column("TOTAL_WEAR_DURATION", horseReinInventoryItem.getTotalWearDuration()), QueryColumn.column("FIT_QUALITY", horseReinInventoryItem.getFitQuality())).execute();
    }

    @Override
    public HorseReinInventoryItem getFromResultRow(ResultRow row) {
        UUID uuid = row.getUuid("UUID");
        int playerId = row.getInt("PLAYER_ID");
        int tackId = row.getInt("TACK_ID");
        long totalWearDuration = row.getLong("TOTAL_WEAR_DURATION");
        double fitQuality = row.getDouble("FIT_QUALITY");
        return new HorseReinInventoryItem(uuid, playerId, tackId, totalWearDuration, fitQuality);
    }

    @Override
    public void update(HorseReinInventoryItem horseReinInventoryItem) {
        Query.update(this.getTableName()).set(QueryColumn.column("TOTAL_WEAR_DURATION", horseReinInventoryItem.getTotalWearDuration()), QueryColumn.column("FIT_QUALITY", horseReinInventoryItem.getFitQuality())).where(QueryColumn.column("UUID", horseReinInventoryItem.getUuid())).execute();
    }
}

