/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.tack.rein;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.tack.HorseTackInfo;
import com.equestricraft.core.player.tack.rein.HorseReinInventoryItem;
import com.equestricraft.core.player.tack.rein.HorseReinInventoryItemRepository;
import com.equestricraft.core.player.tack.rein.HorseReinInventorySession;
import com.equestricraft.core.tack.rein.HorseRein;
import com.equestricraft.core.tack.rein.HorseReinRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class HorseReinInventorySessionImpl
implements HorseReinInventorySession {
    @Service
    private HorseReinRepository horseReinRepository;
    @Service
    private HorseReinInventoryItemRepository horseReinInventoryItemRepository;

    @Override
    public HorseReinInventoryItem addItemToInventory(ECPlayer player, HorseRein tack) {
        HorseReinInventoryItem newItem = new HorseReinInventoryItem(UUID.randomUUID(), player.getId(), tack.getId(), 0L, 0.0);
        this.horseReinInventoryItemRepository.add(newItem);
        return newItem;
    }

    @Override
    public List<UUID> addItemToInventory(ECPlayer player, HorseRein tack, int quantity) {
        ArrayList<UUID> keys2 = new ArrayList<UUID>(quantity);
        for (int i = 0; i < quantity; ++i) {
            HorseReinInventoryItem item = this.addItemToInventory(player, tack);
            keys2.add(item.getUuid());
        }
        return keys2;
    }

    @Override
    public void removeItemFromInventory(UUID key) {
        this.horseReinInventoryItemRepository.removeByKey(key);
    }

    @Override
    public HorseTackInfo<HorseRein, HorseReinInventoryItem> getReinForItem(UUID key) {
        HorseReinInventoryItem item = (HorseReinInventoryItem)this.horseReinInventoryItemRepository.findByKey(key);
        HorseRein tack = (HorseRein)this.horseReinRepository.findByKey(item.getTackId());
        return new HorseTackInfo<HorseRein, HorseReinInventoryItem>(tack, item);
    }
}

