/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.tack.saddle;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.core.player.tack.TackInventoryItemDatabase;
import com.equestricraft.core.player.tack.saddle.HorseSaddleInventoryItem;
import java.util.UUID;

public class HorseSaddleInventoryItemDatabase
extends TackInventoryItemDatabase<HorseSaddleInventoryItem> {
    @Override
    public String getTableName() {
        return "HORSE_SADDLE_INVENTORY_ITEM";
    }

    @Override
    public void create(HorseSaddleInventoryItem horseSaddleInventoryItem) {
        Query.insertInto(this.getTableName()).columns(QueryColumn.column("UUID", horseSaddleInventoryItem.getUuid()), QueryColumn.column("PLAYER_ID", horseSaddleInventoryItem.getPlayerId()), QueryColumn.column("TACK_ID", horseSaddleInventoryItem.getTackId()), QueryColumn.column("TOTAL_WEAR_DURATION", horseSaddleInventoryItem.getTotalWearDuration()), QueryColumn.column("FIT_QUALITY", horseSaddleInventoryItem.getFitQuality())).execute();
    }

    @Override
    public HorseSaddleInventoryItem getFromResultRow(ResultRow row) {
        UUID uuid = row.getUuid("UUID");
        int playerId = row.getInt("PLAYER_ID");
        int tackId = row.getInt("TACK_ID");
        long totalWearDuration = row.getLong("TOTAL_WEAR_DURATION");
        double fitQuality = row.getDouble("FIT_QUALITY");
        return new HorseSaddleInventoryItem(uuid, playerId, tackId, totalWearDuration, fitQuality);
    }

    @Override
    public void update(HorseSaddleInventoryItem horseSaddleInventoryItem) {
        Query.update(this.getTableName()).set(QueryColumn.column("TOTAL_WEAR_DURATION", horseSaddleInventoryItem.getTotalWearDuration()), QueryColumn.column("FIT_QUALITY", horseSaddleInventoryItem.getFitQuality())).where(QueryColumn.column("UUID", horseSaddleInventoryItem.getUuid())).execute();
    }
}

