/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.tack.wraps;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.core.player.tack.TackInventoryItemDatabase;
import com.equestricraft.core.player.tack.wraps.HorseWrapsInventoryItem;
import java.util.UUID;

public class HorseWrapsInventoryItemDatabase
extends TackInventoryItemDatabase<HorseWrapsInventoryItem> {
    @Override
    public String getTableName() {
        return "HORSE_WRAPS_INVENTORY_ITEM";
    }

    @Override
    public void create(HorseWrapsInventoryItem horseWrapsInventoryItem) {
        Query.insertInto(this.getTableName()).columns(QueryColumn.column("UUID", horseWrapsInventoryItem.getUuid()), QueryColumn.column("PLAYER_ID", horseWrapsInventoryItem.getPlayerId()), QueryColumn.column("TACK_ID", horseWrapsInventoryItem.getTackId()), QueryColumn.column("TOTAL_WEAR_DURATION", horseWrapsInventoryItem.getTotalWearDuration()), QueryColumn.column("FIT_QUALITY", horseWrapsInventoryItem.getFitQuality())).execute();
    }

    @Override
    public HorseWrapsInventoryItem getFromResultRow(ResultRow row) {
        UUID uuid = row.getUuid("UUID");
        int playerId = row.getInt("PLAYER_ID");
        int tackId = row.getInt("TACK_ID");
        long totalWearDuration = row.getLong("TOTAL_WEAR_DURATION");
        double fitQuality = row.getDouble("FIT_QUALITY");
        return new HorseWrapsInventoryItem(uuid, playerId, tackId, totalWearDuration, fitQuality);
    }

    @Override
    public void update(HorseWrapsInventoryItem horseWrapsInventoryItem) {
        Query.update(this.getTableName()).set(QueryColumn.column("TOTAL_WEAR_DURATION", horseWrapsInventoryItem.getTotalWearDuration()), QueryColumn.column("FIT_QUALITY", horseWrapsInventoryItem.getFitQuality())).where(QueryColumn.column("UUID", horseWrapsInventoryItem.getUuid())).execute();
    }
}

