/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.token;

import com.equestricraft.base.database.TransactionManagement;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.token.HorseTokenSession;
import com.equestricraft.core.player.token.NotEnoughTokensException;

@TransactionManagement
public class HorseTokenSessionImpl
implements HorseTokenSession {
    @Override
    public void depositHorseCreateTokens(ECPlayer player, int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException(I18n.getLabel("common.zero-or-greater"));
        }
        int currentBalance = player.getTokens().getHorseCreateTokenCount();
        int newBalance = currentBalance + amount;
        player.getCorePlayer().setHorseCreateTokens(newBalance);
        player.getCorePlayer().save();
    }

    @Override
    public void withdrawHorseCreateTokens(ECPlayer player, int amount) throws NotEnoughTokensException {
        if (amount < 0) {
            throw new IllegalArgumentException(I18n.getLabel("common.zero-or-greater"));
        }
        int currentBalance = player.getTokens().getHorseCreateTokenCount();
        if (currentBalance <= 0) {
            throw new NotEnoughTokensException(I18n.getLabel("horse.tokens.create.not-enough"));
        }
        int newBalance = currentBalance - amount;
        player.getCorePlayer().setHorseCreateTokens(newBalance);
        player.getCorePlayer().save();
    }
}

