/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.university;

import com.equestricraft.api.common.APIPlayerUniversityDegreesDto;
import com.equestricraft.api.common.APIPlayerUniversityDto;
import com.equestricraft.api.common.APIPlayerUniversityModulesDto;
import com.equestricraft.api.common.APIUniversityHouseDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.university.PlayerUniversityAccessor;
import com.equestricraft.core.player.university.degree.APIPlayerUniversityDegreesDtoImpl;
import com.equestricraft.core.player.university.module.APIPlayerUniversityModulesDtoImpl;
import com.equestricraft.core.university.house.UniversityHouse;
import com.equestricraft.core.university.house.UniversityHouseTransformer;
import java.util.Optional;

public class APIPlayerUniversityDtoImpl
implements APIPlayerUniversityDto {
    @Service
    private static UniversityHouseTransformer universityHouseTransformer;
    private final PlayerUniversityAccessor playerUniversityAccessor;

    public APIPlayerUniversityDtoImpl(PlayerUniversityAccessor playerUniversityAccessor) {
        this.playerUniversityAccessor = playerUniversityAccessor;
    }

    @Override
    public APIUniversityHouseDto getHouse() {
        Optional<UniversityHouse> house = this.playerUniversityAccessor.getHouse();
        return house.map(universityHouseTransformer::toDto).orElse(null);
    }

    @Override
    public void setHouse(APIUniversityHouseDto house) {
        UniversityHouse h = universityHouseTransformer.fromDto(house);
        this.playerUniversityAccessor.setHouse(h);
    }

    @Override
    public APIPlayerUniversityDegreesDto getDegrees() {
        return new APIPlayerUniversityDegreesDtoImpl(this.playerUniversityAccessor);
    }

    @Override
    public APIPlayerUniversityModulesDto getModules() {
        return new APIPlayerUniversityModulesDtoImpl(this.playerUniversityAccessor);
    }
}

