/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.university;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.CachedValue;
import com.equestricraft.common.DegreeClassification;
import com.equestricraft.core.player.AbstractPlayerAccessor;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.university.CannotAwardException;
import com.equestricraft.core.player.university.UniversityAwardSession;
import com.equestricraft.core.player.university.degree.AlreadyInDegreeException;
import com.equestricraft.core.player.university.degree.NotInDegreeException;
import com.equestricraft.core.player.university.degree.PlayerDegreeInfoDto;
import com.equestricraft.core.player.university.degree.UniversityDegreePlayerSession;
import com.equestricraft.core.player.university.module.UniversityModuleResult;
import com.equestricraft.core.player.university.module.UniversityModuleResultSession;
import com.equestricraft.core.university.UniversityModuleInfo;
import com.equestricraft.core.university.UniversitySession;
import com.equestricraft.core.university.house.UniversityHouse;
import com.equestricraft.core.university.house.UniversityHouseSession;
import com.equestricraft.core.university.module.UniversityModule;
import com.equestricraft.dataload.DataLoadModule;
import com.equestricraft.dataload.DataLoadSubscriber;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

public class PlayerUniversityAccessor
extends AbstractPlayerAccessor {
    @Service
    private static UniversityHouseSession universityHouseSession;
    @Service
    private static UniversitySession universitySession;
    @Service
    private static UniversityDegreePlayerSession universityDegreePlayerSession;
    @Service
    private static UniversityModuleResultSession universityModuleResultSession;
    @Service
    private static UniversityAwardSession universityAwardSession;
    private static final DataLoadSubscriber universityUpdateSubscriber;
    private final CachedValue<UniversityHouse> house = new CachedValue<UniversityHouse>(this::getUpdatedHouse);

    public PlayerUniversityAccessor(CorePlayer player) {
        super(player);
        universityUpdateSubscriber.subscribe(this.house::expire);
    }

    public Optional<UniversityHouse> getHouse() {
        return Optional.ofNullable(this.house.get());
    }

    public void setHouse(UniversityHouse house) {
        universityHouseSession.setPlayersUniversityHouse(this.player, house);
        this.house.set(house);
    }

    public List<PlayerDegreeInfoDto> getDegrees() {
        return universitySession.getDegreesListForPlayer(this.player);
    }

    public List<UniversityModuleInfo> getModules() {
        return universitySession.getModulesPlayerCanAccess(this.player);
    }

    public void startDegree(int degreeId) throws AlreadyInDegreeException {
        universityDegreePlayerSession.startDegreeForPlayer(this.player, degreeId);
    }

    public void awardDegree(int degreeId) throws NotInDegreeException, CannotAwardException {
        universityAwardSession.awardPlayerWithDegree(this.player, degreeId);
    }

    public boolean hasBeenAwardedDegree(int degreeId, Duration duration) {
        return universityDegreePlayerSession.hasPlayerBeenAwardedDegree(this.player, degreeId, duration);
    }

    public Optional<PlayerDegreeInfoDto> getDegreeInfo(int degreeId) {
        return universitySession.getDegreeInfoForPlayer(this.player, degreeId);
    }

    public Optional<DegreeClassification> getPlayersClassificationForDegree(int degreeId) {
        return universityDegreePlayerSession.getPlayersClassificationForDegree(this.player, degreeId);
    }

    public boolean hasBeenAwardedAtLeastClassification(int degreeId, DegreeClassification minimumClassification) {
        Optional<DegreeClassification> playersClassification = this.getPlayersClassificationForDegree(degreeId);
        return playersClassification.filter(c -> c.ordinal() >= minimumClassification.ordinal()).isPresent();
    }

    public void setModulePracticalResult(int moduleId, boolean passed) {
        universityModuleResultSession.setModulePracticalResult(this.player, moduleId, passed);
    }

    public Optional<UniversityModuleResult> getModuleResult(UniversityModule module) {
        return universityModuleResultSession.getResultForModuleForPlayer(this.player, module.getId());
    }

    public boolean hasPassForModule(UniversityModule module) {
        Optional<UniversityModuleResult> result = this.getModuleResult(module);
        if (result.isPresent()) {
            if (result.get().getExamPercentage() != null) {
                return result.get().getExamPercentage() >= module.getPassMark();
            }
            return false;
        }
        return false;
    }

    private UniversityHouse getUpdatedHouse() {
        return universityHouseSession.getPlayersUniversityHouse(this.player).orElse(null);
    }

    static {
        universityUpdateSubscriber = new DataLoadSubscriber(DataLoadModule.UNIVERSITY);
    }
}

