/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.university;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.DegreeClassification;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.university.CannotAwardException;
import com.equestricraft.core.player.university.UniversityAwardSession;
import com.equestricraft.core.player.university.degree.NotInDegreeException;
import com.equestricraft.core.player.university.degree.UniversityDegreePlayerSession;
import com.equestricraft.core.player.university.module.UniversityModuleResult;
import com.equestricraft.core.player.university.module.UniversityModuleResultRepository;
import com.equestricraft.core.university.UniversityDegreeModuleInfo;
import com.equestricraft.core.university.UniversitySettings;
import com.equestricraft.core.university.degreemodule.UniversityDegreeModule;
import com.equestricraft.core.university.degreemodule.UniversityDegreeModuleRepository;
import com.equestricraft.core.university.module.UniversityModule;
import com.equestricraft.core.university.module.UniversityModuleRepository;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class UniversityAwardSessionImpl
implements UniversityAwardSession {
    @Service
    private UniversityDegreeModuleRepository universityDegreeModuleRepository;
    @Service
    private UniversityModuleRepository universityModuleRepository;
    @Service
    private UniversityModuleResultRepository universityModuleResultRepository;
    @Service
    private UniversityDegreePlayerSession universityDegreePlayerSession;

    @Override
    public void awardPlayerWithDegree(ECPlayer player, int degreeId) throws CannotAwardException, NotInDegreeException {
        List<UniversityDegreeModuleInfo> modules = this.findModulesForDegree(degreeId);
        double degreePercentage = this.calculatePlayersOverallPercentage(player, modules);
        DegreeClassification classification = this.calculateDegreeClassification(degreePercentage).orElseThrow(() -> new CannotAwardException(I18n.getLabel("university.award.not-high-enough-percentage")));
        try {
            this.universityDegreePlayerSession.awardDegreeToPlayer(player, degreeId, classification);
        }
        catch (EconomyException ex) {
            throw new CannotAwardException(ex.getMessage());
        }
    }

    private List<UniversityDegreeModuleInfo> findModulesForDegree(int degreeId) {
        List<UniversityDegreeModule> degreeModules = this.universityDegreeModuleRepository.findModulesByDegreeId(degreeId);
        List<UniversityModule> modules = this.findModules(degreeModules);
        return this.buildModuleInfoList(degreeModules, modules);
    }

    private List<UniversityModule> findModules(List<UniversityDegreeModule> degreeModules) {
        List<Integer> moduleIds = degreeModules.stream().map(UniversityDegreeModule::getModuleId).toList();
        return this.universityModuleRepository.findByKeys(moduleIds);
    }

    private List<UniversityDegreeModuleInfo> buildModuleInfoList(List<UniversityDegreeModule> degreeModules, List<UniversityModule> modules) {
        int totalWeight = this.calculateTotalWeight(degreeModules);
        ArrayList<UniversityDegreeModuleInfo> infoList = new ArrayList<UniversityDegreeModuleInfo>(modules.size());
        for (UniversityDegreeModule degreeModule : degreeModules) {
            UniversityModule module = modules.stream().filter(m -> m.getId() == degreeModule.getModuleId()).findFirst().orElseThrow();
            UniversityDegreeModuleInfo moduleInfo = new UniversityDegreeModuleInfo(module.getId(), module.getName(), module.getDescription(), module.getExamLastUpdated(), (double)degreeModule.getWeight() / (double)totalWeight, module.getPassMark(), module.isRequirePracticalExam());
            infoList.add(moduleInfo);
        }
        return infoList;
    }

    private int calculateTotalWeight(List<UniversityDegreeModule> degreeModules) {
        return degreeModules.stream().mapToInt(UniversityDegreeModule::getWeight).sum();
    }

    private double calculatePlayersOverallPercentage(ECPlayer player, List<UniversityDegreeModuleInfo> modules) throws CannotAwardException {
        LinkedList<String> failReasons = new LinkedList<String>();
        double degreePercentage = 0.0;
        for (UniversityDegreeModuleInfo module : modules) {
            try {
                double percentageTowardsDegree = this.calculatePercentageForModule(player, module);
                degreePercentage += percentageTowardsDegree;
            }
            catch (CannotAwardException ex) {
                failReasons.add(I18n.getLabel("university.award.module-not-passed", module.moduleName(), ex.getMessage()));
            }
        }
        if (ListUtils.isNotEmpty(failReasons)) {
            String reason = String.join((CharSequence)"\n", failReasons);
            throw new CannotAwardException(String.format("%s%n%s", I18n.getLabel("university.award.not-all-modules-passed"), reason));
        }
        return degreePercentage;
    }

    private double calculatePercentageForModule(ECPlayer player, UniversityDegreeModuleInfo module) throws CannotAwardException {
        Date passedDate;
        int daysSincePassed;
        UniversityModuleResult moduleResult = this.universityModuleResultRepository.findByPlayerAndModule(player.getId(), module.moduleId()).orElseThrow(() -> new CannotAwardException(I18n.getLabel("university.award.module-not-completed")));
        if (moduleResult.getPracticalPassed() == null || moduleResult.getPracticalPassed().booleanValue()) {
            throw new CannotAwardException(I18n.getLabel("university.award.module-practical-needed"));
        }
        if (moduleResult.getExamPercentage() == null || moduleResult.getExamPercentage() < module.passMark()) {
            throw new CannotAwardException(I18n.getLabel("university.award.module-exam-not-passed"));
        }
        if (moduleResult.getExamResultTimeStamp() != null && (daysSincePassed = DateUtils.daysSince(passedDate = new Date(moduleResult.getExamResultTimeStamp()))) > UniversitySettings.getExamUpdateImmunity() && passedDate.before(module.examLastUpdated())) {
            throw new CannotAwardException(I18n.getLabel("university.award.module-pass-expired"));
        }
        float factor = (float)(module.weightPercentage() / 100.0);
        return factor * (float)moduleResult.getExamPercentage().intValue();
    }

    private Optional<DegreeClassification> calculateDegreeClassification(double percentage) {
        for (DegreeClassification classification : DegreeClassification.values()) {
            if (!(classification.getPercentageThreshold() <= percentage)) continue;
            return Optional.of(classification);
        }
        return Optional.empty();
    }
}

