/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.university.degree;

import com.equestricraft.api.common.APIDurationDto;
import com.equestricraft.api.common.APIPlayerUniversityDegreeDto;
import com.equestricraft.api.common.APIResponse;
import com.equestricraft.api.common.APIUniversityDegreeClassificationDto;
import com.equestricraft.api.common.APIUniversityDegreeDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.player.university.CannotAwardException;
import com.equestricraft.core.player.university.PlayerUniversityAccessor;
import com.equestricraft.core.player.university.degree.APIUniversityDegreeClassificationDtoImpl;
import com.equestricraft.core.player.university.degree.AlreadyInDegreeException;
import com.equestricraft.core.player.university.degree.NotInDegreeException;
import com.equestricraft.core.player.university.degree.PlayerDegreeInfoDto;
import com.equestricraft.core.university.degree.UniversityDegree;
import com.equestricraft.core.university.degree.UniversityDegreeTransformer;
import java.util.Date;
import java.util.Optional;

public class APIPlayerUniversityDegreeDtoImpl
implements APIPlayerUniversityDegreeDto {
    private final UniversityDegree degree;
    private final PlayerUniversityAccessor playerUniversityAccessor;
    @Service
    private static UniversityDegreeTransformer universityDegreeTransformer;

    public APIPlayerUniversityDegreeDtoImpl(UniversityDegree degree, PlayerUniversityAccessor playerUniversityAccessor) {
        this.degree = degree;
        this.playerUniversityAccessor = playerUniversityAccessor;
    }

    @Override
    public APIUniversityDegreeDto getDegree() {
        return universityDegreeTransformer.toDto(this.degree);
    }

    @Override
    public APIResponse start() {
        try {
            this.playerUniversityAccessor.startDegree(this.degree.getId());
            return APIResponse.success();
        }
        catch (AlreadyInDegreeException ex) {
            return APIResponse.fail(ex.getMessage());
        }
    }

    @Override
    public APIResponse award() {
        try {
            this.playerUniversityAccessor.awardDegree(this.degree.getId());
            return APIResponse.success();
        }
        catch (CannotAwardException | NotInDegreeException ex) {
            return APIResponse.fail(ex.getMessage());
        }
    }

    @Override
    public Date getStartDate() {
        Optional<PlayerDegreeInfoDto> info2 = this.playerUniversityAccessor.getDegreeInfo(this.degree.getId());
        return info2.map(PlayerDegreeInfoDto::startedDate).orElse(null);
    }

    @Override
    public APIDurationDto getDurationSinceStarted() {
        return this.playerUniversityAccessor.getDegreeInfo(this.degree.getId()).map(i -> DateUtils.durationSince(i.startedDate())).map(APIDurationDto::new).orElse(null);
    }

    @Override
    public Date getFinishDate() {
        Optional<PlayerDegreeInfoDto> info2 = this.playerUniversityAccessor.getDegreeInfo(this.degree.getId());
        return info2.map(PlayerDegreeInfoDto::finishedDate).orElse(null);
    }

    @Override
    public APIDurationDto getDurationSinceFinished() {
        return this.playerUniversityAccessor.getDegreeInfo(this.degree.getId()).map(i -> DateUtils.durationSince(i.finishedDate())).map(APIDurationDto::new).orElse(null);
    }

    @Override
    public APIUniversityDegreeClassificationDto getClassification() {
        Optional<PlayerDegreeInfoDto> info2 = this.playerUniversityAccessor.getDegreeInfo(this.degree.getId());
        return info2.map(PlayerDegreeInfoDto::classification).map(APIUniversityDegreeClassificationDtoImpl::new).orElse(null);
    }
}

