/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.university.degree;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.cdi.Services;
import com.equestricraft.common.DegreeClassification;
import com.equestricraft.core.player.university.degree.UniversityDegreePlayerKey;
import com.equestricraft.core.player.university.degree.UniversityDegreePlayerRepository;
import java.util.Objects;

public class UniversityDegreePlayer
implements RepositoryEntity<UniversityDegreePlayerKey> {
    private final UniversityDegreePlayerKey key;
    private final long startDate;
    private Long awardDate;
    private DegreeClassification classification;

    public UniversityDegreePlayer(int playerId, int degreeId, long startDate, Long awardDate, DegreeClassification classification) {
        this.key = new UniversityDegreePlayerKey(playerId, degreeId);
        this.startDate = startDate;
        this.awardDate = awardDate;
        this.classification = classification;
    }

    @Override
    public UniversityDegreePlayerKey getKey() {
        return this.key;
    }

    public int getPlayerId() {
        return this.getKey().playerId();
    }

    public int getDegreeId() {
        return this.getKey().degreeId();
    }

    public long getStartDate() {
        return this.startDate;
    }

    public Long getAwardDate() {
        return this.awardDate;
    }

    public void setAwardDate(Long awardDate) {
        this.awardDate = awardDate;
    }

    public DegreeClassification getClassification() {
        return this.classification;
    }

    public void setClassification(DegreeClassification classification) {
        this.classification = classification;
    }

    @Override
    public void save() {
        Services.getService(UniversityDegreePlayerRepository.class).update(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniversityDegreePlayer that = (UniversityDegreePlayer)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }
}

