/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.university.degree;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.DegreeClassification;
import com.equestricraft.core.player.university.degree.UniversityDegreePlayer;
import com.equestricraft.core.player.university.degree.UniversityDegreePlayerKey;
import java.util.List;

public class UniversityDegreePlayerDatabase
implements RepositoryDatasource<UniversityDegreePlayer, UniversityDegreePlayerKey> {
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_DEGREE_ID = "DEGREE_ID";
    private static final String COLUMN_START_DATE = "START_DATE";
    private static final String COLUMN_AWARD_DATE = "AWARD_DATE";
    private static final String COLUMN_CLASSIFICATION = "CLASSIFICATION";

    @Override
    public List<UniversityDegreePlayer> retrieveAll() {
        return Query.selectAllFrom("UNIVERSITY_DEGREE_PLAYER").getList(this::getFromResultRow);
    }

    private UniversityDegreePlayer getFromResultRow(ResultRow row) {
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        int degreeId = row.getInt(COLUMN_DEGREE_ID);
        long startDate = row.getLong(COLUMN_START_DATE);
        Long awardDate = row.getNullableLong(COLUMN_AWARD_DATE);
        DegreeClassification degreeClassification = row.getNullableEnum(COLUMN_CLASSIFICATION, DegreeClassification.class);
        return new UniversityDegreePlayer(playerId, degreeId, startDate, awardDate, degreeClassification);
    }

    @Override
    public void update(UniversityDegreePlayer universityDegreePlayer) {
        Query.update("UNIVERSITY_DEGREE_PLAYER").set(QueryColumn.column(COLUMN_AWARD_DATE, universityDegreePlayer.getAwardDate()), QueryColumn.column(COLUMN_CLASSIFICATION, universityDegreePlayer.getClassification())).where(QueryColumn.column(COLUMN_PLAYER_ID, universityDegreePlayer.getPlayerId()), QueryColumn.column(COLUMN_DEGREE_ID, universityDegreePlayer.getDegreeId())).execute();
    }
}

