/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.university.degree;

import com.equestricraft.base.database.TransactionManagement;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.DegreeClassification;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.university.degree.AlreadyInDegreeException;
import com.equestricraft.core.player.university.degree.NotInDegreeException;
import com.equestricraft.core.player.university.degree.UniversityDegreePlayer;
import com.equestricraft.core.player.university.degree.UniversityDegreePlayerRepository;
import com.equestricraft.core.player.university.degree.UniversityDegreePlayerSession;
import com.equestricraft.core.university.degree.UniversityDegree;
import com.equestricraft.core.university.degree.UniversityDegreeRepository;
import java.time.Duration;
import java.util.Optional;

@TransactionManagement
public class UniversityDegreePlayerSessionImpl
implements UniversityDegreePlayerSession {
    @Service
    private UniversityDegreePlayerRepository universityDegreePlayerRepository;
    @Service
    private UniversityDegreeRepository universityDegreeRepository;

    @Override
    public void startDegreeForPlayer(ECPlayer player, int degreeId) throws AlreadyInDegreeException {
        Optional<UniversityDegreePlayer> existing = this.universityDegreePlayerRepository.findByPlayerAndDegree(player.getId(), degreeId);
        if (existing.isPresent()) {
            throw new AlreadyInDegreeException();
        }
        UniversityDegreePlayer playerDegree = new UniversityDegreePlayer(player.getId(), degreeId, System.currentTimeMillis(), null, null);
        this.universityDegreePlayerRepository.add(playerDegree);
    }

    @Override
    public void awardDegreeToPlayer(ECPlayer player, int degreeId, DegreeClassification degreeClassification) throws NotInDegreeException, EconomyException {
        UniversityDegreePlayer playerDegree = this.universityDegreePlayerRepository.findByPlayerAndDegree(player.getId(), degreeId).orElseThrow(NotInDegreeException::new);
        this.withdrawAwardFee(player, degreeId);
        playerDegree.setAwardDate(System.currentTimeMillis());
        playerDegree.setClassification(degreeClassification);
        playerDegree.save();
    }

    private void withdrawAwardFee(ECPlayer player, int degreeId) throws EconomyException {
        UniversityDegree degree = (UniversityDegree)this.universityDegreeRepository.findByKey(degreeId);
        double fee = degree.getAwardFee();
        if (fee > 0.0) {
            player.getEconomy().withdraw(fee, I18n.getLabel("university.degree-award-payment", degree.getName()), "University");
        }
    }

    @Override
    public boolean hasPlayerBeenAwardedDegree(ECPlayer player, int degreeId, Duration duration) {
        Optional<UniversityDegreePlayer> playerDegree = this.universityDegreePlayerRepository.findByPlayerAndDegree(player.getId(), degreeId);
        return playerDegree.map(d -> this.hasDegreeBeenAwardedWithDuration((UniversityDegreePlayer)d, duration)).orElse(false);
    }

    @Override
    public Optional<DegreeClassification> getPlayersClassificationForDegree(ECPlayer player, int degreeId) {
        Optional<UniversityDegreePlayer> result = this.universityDegreePlayerRepository.findByPlayerAndDegree(player.getId(), degreeId);
        return result.map(UniversityDegreePlayer::getClassification);
    }

    private boolean hasDegreeBeenAwardedWithDuration(UniversityDegreePlayer result, Duration duration) {
        Long awardDate = result.getAwardDate();
        if (awardDate == null) {
            return false;
        }
        if (duration == null || duration.toMillis() == 0L) {
            return true;
        }
        long millisSince = DateUtils.millisSince(awardDate);
        return millisSince <= duration.toMillis();
    }
}

