/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.university.module;

import com.equestricraft.api.common.APIDurationDto;
import com.equestricraft.api.common.APIPlayerUniversityModuleDto;
import com.equestricraft.api.common.APIUniversityModuleDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.player.university.PlayerUniversityAccessor;
import com.equestricraft.core.player.university.module.UniversityModuleResult;
import com.equestricraft.core.university.module.UniversityModule;
import com.equestricraft.core.university.module.UniversityModuleTransformer;
import java.time.Duration;
import java.util.Date;
import java.util.Optional;

public class APIPlayerUniversityModuleDtoImpl
implements APIPlayerUniversityModuleDto {
    private final UniversityModule module;
    private final PlayerUniversityAccessor playerUniversityAccessor;
    @Service
    private static UniversityModuleTransformer universityModuleTransformer;

    public APIPlayerUniversityModuleDtoImpl(UniversityModule module, PlayerUniversityAccessor playerUniversityAccessor) {
        this.module = module;
        this.playerUniversityAccessor = playerUniversityAccessor;
    }

    @Override
    public APIUniversityModuleDto getModule() {
        return universityModuleTransformer.toDto(this.module);
    }

    @Override
    public Date getExamTime() {
        return this.playerUniversityAccessor.getModuleResult(this.module).map(UniversityModuleResult::getExamResultTimeStamp).map(Date::new).orElse(null);
    }

    @Override
    public APIDurationDto getDurationSinceExam() {
        Date date = this.getExamTime();
        if (date != null) {
            Duration duration = DateUtils.durationSince(date);
            return new APIDurationDto(duration);
        }
        return null;
    }

    @Override
    public Integer getExamPercentage() {
        Optional<UniversityModuleResult> result = this.playerUniversityAccessor.getModuleResult(this.module);
        return result.map(UniversityModuleResult::getExamPercentage).orElse(null);
    }

    @Override
    public Date getPracticalExamTime() {
        return this.playerUniversityAccessor.getModuleResult(this.module).map(UniversityModuleResult::getPracticalResultTimeStamp).map(Date::new).orElse(null);
    }

    @Override
    public APIDurationDto getDurationSincePracticalExam() {
        Date date = this.getPracticalExamTime();
        if (date != null) {
            Duration duration = DateUtils.durationSince(date);
            return new APIDurationDto(duration);
        }
        return null;
    }

    @Override
    public Boolean getPracticalExamPassed() {
        Optional<UniversityModuleResult> result = this.playerUniversityAccessor.getModuleResult(this.module);
        return result.map(UniversityModuleResult::getPracticalPassed).orElse(null);
    }

    @Override
    public void setPracticalExamPassed(Boolean passed) {
        this.playerUniversityAccessor.setModulePracticalResult(this.module.getId(), passed);
    }

    @Override
    public boolean getPassedModule() {
        return this.playerUniversityAccessor.hasPassForModule(this.module);
    }
}

