/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.university.module;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.player.university.module.UniversityModuleResultKey;
import com.equestricraft.core.player.university.module.UniversityModuleResultRepository;
import java.util.Objects;

public class UniversityModuleResult
implements RepositoryEntity<UniversityModuleResultKey> {
    private final UniversityModuleResultKey key;
    private Long examResultTimeStamp;
    private Integer examPercentage;
    private Long practicalResultTimeStamp;
    private Boolean practicalPassed;

    public UniversityModuleResult(int playerId, int moduleId, Long examResultTimeStamp, Integer examPercentage, Long practicalResultTimeStamp, Boolean practicalPassed) {
        this.key = new UniversityModuleResultKey(playerId, moduleId);
        this.examResultTimeStamp = examResultTimeStamp;
        this.examPercentage = examPercentage;
        this.practicalResultTimeStamp = practicalResultTimeStamp;
        this.practicalPassed = practicalPassed;
    }

    @Override
    public UniversityModuleResultKey getKey() {
        return this.key;
    }

    public int getPlayerId() {
        return this.getKey().playerId();
    }

    public int getModuleId() {
        return this.getKey().moduleId();
    }

    public Long getExamResultTimeStamp() {
        return this.examResultTimeStamp;
    }

    public void setExamResultTimeStamp(Long examResultTimeStamp) {
        this.examResultTimeStamp = examResultTimeStamp;
    }

    public Integer getExamPercentage() {
        return this.examPercentage;
    }

    public void setExamPercentage(Integer examPercentage) {
        this.examPercentage = examPercentage;
    }

    public Long getPracticalResultTimeStamp() {
        return this.practicalResultTimeStamp;
    }

    public void setPracticalResultTimeStamp(Long practicalResultTimeStamp) {
        this.practicalResultTimeStamp = practicalResultTimeStamp;
    }

    public Boolean getPracticalPassed() {
        return this.practicalPassed;
    }

    public void setPracticalPassed(Boolean practicalPassed) {
        this.practicalPassed = practicalPassed;
    }

    @Override
    public void save() {
        Services.getService(UniversityModuleResultRepository.class).update(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniversityModuleResult that = (UniversityModuleResult)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }
}

