/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.university.module;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.player.university.module.UniversityModuleResult;
import com.equestricraft.core.player.university.module.UniversityModuleResultKey;
import java.util.List;

public class UniversityModuleResultDatabase
implements RepositoryDatasource<UniversityModuleResult, UniversityModuleResultKey> {
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_MODULE_ID = "MODULE_ID";
    private static final String COLUMN_EXAM_RESULT_TIME_STAMP = "EXAM_RESULT_TIME_STAMP";
    private static final String COLUMN_EXAM_PERCENTAGE = "EXAM_PERCENTAGE";
    private static final String COLUMN_PRACTICAL_RESULT_TIME_STAMP = "PRACTICAL_RESULT_TIME_STAMP";
    private static final String COLUMN_PRACTICAL_PASSED = "PRACTICAL_PASSED";

    @Override
    public void create(UniversityModuleResult universityModuleResult) {
        Query.insertInto("UNIVERSITY_MODULE_RESULT").columns(QueryColumn.column(COLUMN_PLAYER_ID, universityModuleResult.getPlayerId()), QueryColumn.column(COLUMN_MODULE_ID, universityModuleResult.getModuleId()), QueryColumn.column(COLUMN_EXAM_RESULT_TIME_STAMP, universityModuleResult.getExamResultTimeStamp()), QueryColumn.column(COLUMN_EXAM_PERCENTAGE, universityModuleResult.getExamPercentage()), QueryColumn.column(COLUMN_PRACTICAL_RESULT_TIME_STAMP, universityModuleResult.getPracticalResultTimeStamp()), QueryColumn.column(COLUMN_PRACTICAL_PASSED, universityModuleResult.getPracticalPassed())).execute();
    }

    @Override
    public List<UniversityModuleResult> retrieveAll() {
        return Query.selectAllFrom("UNIVERSITY_MODULE_RESULT").getList(this::getFromResultRow);
    }

    private UniversityModuleResult getFromResultRow(ResultRow row) {
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        int moduleId = row.getInt(COLUMN_MODULE_ID);
        Long examResultTimeStamp = row.getNullableLong(COLUMN_EXAM_RESULT_TIME_STAMP);
        Integer examPercentage = row.getNullableInt(COLUMN_EXAM_PERCENTAGE);
        Long practicalResultTimeStamp = row.getNullableLong(COLUMN_PRACTICAL_RESULT_TIME_STAMP);
        Boolean practicalPassed = row.getNullableBoolean(COLUMN_PRACTICAL_PASSED);
        return new UniversityModuleResult(playerId, moduleId, examResultTimeStamp, examPercentage, practicalResultTimeStamp, practicalPassed);
    }

    @Override
    public void update(UniversityModuleResult universityModuleResult) {
        Query.update("UNIVERSITY_MODULE_RESULT").set(QueryColumn.column(COLUMN_EXAM_RESULT_TIME_STAMP, universityModuleResult.getExamResultTimeStamp()), QueryColumn.column(COLUMN_EXAM_PERCENTAGE, universityModuleResult.getExamPercentage()), QueryColumn.column(COLUMN_PRACTICAL_RESULT_TIME_STAMP, universityModuleResult.getPracticalResultTimeStamp()), QueryColumn.column(COLUMN_PRACTICAL_PASSED, universityModuleResult.getPracticalPassed())).where(QueryColumn.column(COLUMN_PLAYER_ID, universityModuleResult.getPlayerId()), QueryColumn.column(COLUMN_MODULE_ID, universityModuleResult.getModuleId())).execute();
    }
}

