/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.university.module;

import com.equestricraft.base.database.TransactionManagement;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.university.module.UniversityModuleResult;
import com.equestricraft.core.player.university.module.UniversityModuleResultRepository;
import com.equestricraft.core.player.university.module.UniversityModuleResultSession;
import com.equestricraft.core.university.module.UniversityModule;
import com.equestricraft.core.university.module.UniversityModuleRepository;
import java.util.Optional;

@TransactionManagement
public class UniversityModuleResultSessionImpl
implements UniversityModuleResultSession {
    @Service
    private UniversityModuleResultRepository universityModuleResultRepository;
    @Service
    private UniversityModuleRepository universityModuleRepository;
    @Service
    private PlayerRepository playerRepository;

    @Override
    public void setModuleExamResult(ECPlayer player, int moduleId, int percentage) throws EconomyException {
        Optional<UniversityModuleResult> existing = this.universityModuleResultRepository.findByPlayerAndModule(player.getId(), moduleId);
        if (existing.isPresent()) {
            this.setModulePercentage(existing.get(), percentage);
        } else {
            this.addNewResult(player, moduleId, percentage, null);
        }
    }

    private void setModulePercentage(UniversityModuleResult result, int percentage) throws EconomyException {
        UniversityModule module = (UniversityModule)this.universityModuleRepository.findByKey(result.getModuleId());
        if (this.hasPlayerFailedExam(result, module)) {
            this.withdrawResitFee(result.getPlayerId(), module);
        }
        result.setExamResultTimeStamp(System.currentTimeMillis());
        result.setExamPercentage(percentage);
        result.save();
    }

    private boolean hasPlayerFailedExam(UniversityModuleResult existingResult, UniversityModule module) {
        return existingResult.getExamPercentage() != null && existingResult.getExamPercentage() < module.getPassMark();
    }

    private void withdrawResitFee(int playerId, UniversityModule module) throws EconomyException {
        double resitFee = module.getResitFee();
        if (resitFee > 0.0) {
            CorePlayer player = (CorePlayer)this.playerRepository.findByKey(playerId);
            player.getEconomy().withdraw(resitFee, I18n.getLabel("university.module-reset-payment", module.getName()), "University");
        }
    }

    @Override
    public void setModulePracticalResult(ECPlayer player, int moduleId, boolean passedPractical) {
        Optional<UniversityModuleResult> existing = this.universityModuleResultRepository.findByPlayerAndModule(player.getId(), moduleId);
        if (existing.isPresent()) {
            this.setModulePassedPractical(existing.get(), passedPractical);
        } else {
            this.addNewResult(player, moduleId, null, passedPractical);
        }
    }

    private void setModulePassedPractical(UniversityModuleResult result, boolean passedPractical) {
        result.setPracticalResultTimeStamp(System.currentTimeMillis());
        result.setPracticalPassed(passedPractical);
        result.save();
    }

    private void addNewResult(ECPlayer player, int moduleId, Integer percentage, Boolean passedPractical) {
        long timeNow = System.currentTimeMillis();
        Long examTime = percentage != null ? Long.valueOf(timeNow) : null;
        Long practicalTime = passedPractical != null ? Long.valueOf(timeNow) : null;
        UniversityModuleResult result = new UniversityModuleResult(player.getId(), moduleId, examTime, percentage, practicalTime, passedPractical);
        this.universityModuleResultRepository.add(result);
    }

    @Override
    public boolean hasPlayerFailedExam(ECPlayer player, int moduleId) {
        Optional<UniversityModuleResult> result = this.universityModuleResultRepository.findByPlayerAndModule(player.getId(), moduleId);
        if (result.isPresent()) {
            UniversityModule module = (UniversityModule)this.universityModuleRepository.findByKey(moduleId);
            return this.hasPlayerFailedExam(result.get(), module);
        }
        return false;
    }

    @Override
    public Optional<UniversityModuleResult> getResultForModuleForPlayer(ECPlayer player, int moduleId) {
        return this.universityModuleResultRepository.findByPlayerAndModule(player.getId(), moduleId);
    }
}

