/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.xp;

import com.equestricraft.base.database.TransactionManagement;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.xp.XPSession;
import com.equestricraft.logging.Log;

@TransactionManagement
public class XPSessionImpl
implements XPSession {
    private static final Log log = Log.getLogger(XPSessionImpl.class.getName());

    @Override
    public void giveXpToPlayer(CorePlayer player, int xpToGive) {
        if (xpToGive < 0) {
            throw new IllegalArgumentException("XP must be 0 or greater");
        }
        if (xpToGive == 0) {
            return;
        }
        int currentXp = player.getXp();
        player.setXp(currentXp + xpToGive);
        player.save();
        log.info("Given {}XP to player {}", (Object)xpToGive, (Object)player.getId());
    }

    @Override
    public boolean takeXpFromPlayer(CorePlayer player, int xpToTake) {
        if (xpToTake < 0) {
            throw new IllegalArgumentException("XP must be 0 or greater");
        }
        if (xpToTake == 0) {
            return true;
        }
        int currentXp = player.getXp();
        if (currentXp < xpToTake) {
            return false;
        }
        player.setXp(currentXp - xpToTake);
        player.save();
        log.info("Taken {}XP from player {}", (Object)xpToTake, (Object)player.getId());
        return true;
    }
}

