/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.plot;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.cdi.Services;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.plot.PlotAdapter;
import com.equestricraft.core.plot.PlotRepository;
import com.equestricraft.core.plot.PlotType;
import java.util.List;
import java.util.Objects;

public abstract class Plot
extends PlotAdapter
implements RepositoryEntity<Integer> {
    private int id;
    private String name;
    private DirectionalCoordinate spawnPoint;
    private List<Integer> ownerIds;

    protected Plot(int id, String name, DirectionalCoordinate spawnPoint, List<Integer> ownerIds) {
        this.id = id;
        this.name = name;
        this.spawnPoint = spawnPoint;
        this.ownerIds = ownerIds;
    }

    @Override
    public Integer getKey() {
        return this.getId();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DirectionalCoordinate getSpawnPoint() {
        return this.spawnPoint;
    }

    public void setSpawnPoint(DirectionalCoordinate spawnPoint) {
        this.spawnPoint = spawnPoint;
    }

    @Override
    public List<Integer> getOwnerIds() {
        return this.ownerIds;
    }

    public void setOwnerIds(List<Integer> ownerIds) {
        this.ownerIds = ownerIds;
    }

    public abstract PlotType getPlotType();

    @Override
    public void save() {
        Services.getService(PlotRepository.class).update(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plot plot = (Plot)o;
        return this.id == plot.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.name;
    }
}

