/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.plot;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.coordinate.Area2D;
import com.equestricraft.common.coordinate.AreaUtility;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.common.coordinate.Point2D;
import com.equestricraft.core.plot.NaturalPlot;
import com.equestricraft.core.plot.NaturalPlotArea;
import com.equestricraft.core.plot.PlotAreaSession;
import com.equestricraft.core.plot.PlotNearbyAreaMapItem;
import com.equestricraft.core.plot.PlotNearbyAreaType;
import com.equestricraft.core.plot.PlotRepository;
import com.equestricraft.core.plot.setting.PlotGlobalSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PlotAreaSessionImpl
implements PlotAreaSession {
    @Service
    private PlotRepository plotRepository;
    private static final int NEARBY_PLOT_MAP_RADIUS = 100;

    @Override
    public List<Area2D> retrieveAreasForPlot(NaturalPlot plot) {
        return plot.getPlotAreas().stream().map(this::toArea2D).toList();
    }

    @Override
    public List<PlotNearbyAreaMapItem> retrieveNearbyConflictAreas(Area2D targetArea) {
        return this.retrieveNearbyConflictAreas(targetArea, null);
    }

    @Override
    public List<PlotNearbyAreaMapItem> retrieveNearbyConflictAreas(Area2D targetArea, Integer excludePlot) {
        PlotGlobalSettings settings = PlotGlobalSettings.get();
        record AreaGroup(boolean isSpawn, List<Area2D> areas) {
        }
        ArrayList<AreaGroup> areaGroups = new ArrayList<AreaGroup>();
        List<NaturalPlot> allPlots = this.plotRepository.findAllNaturalPlots();
        for (NaturalPlot plot : allPlots) {
            if (excludePlot != null && plot.getId() == excludePlot.intValue()) continue;
            List<Area2D> areasInPlot = this.retrieveAreasForPlot(plot);
            areaGroups.add(new AreaGroup(false, areasInPlot));
        }
        DirectionalCoordinate worldSpawn = settings.getSpawnPoint();
        int worldSpawnRadius = settings.getSpawnPointProtectionRadius();
        Area2D spawnArea = AreaUtility.createAreaFromPointAndRadius(new Point2D((int)worldSpawn.x(), (int)worldSpawn.z()), worldSpawnRadius);
        areaGroups.add(new AreaGroup(true, Collections.singletonList(spawnArea)));
        ArrayList<PlotNearbyAreaMapItem> areasToReturn = new ArrayList<PlotNearbyAreaMapItem>();
        for (AreaGroup areaGroup : areaGroups) {
            boolean hasNearbyArea = areaGroup.areas().stream().anyMatch(a -> a.withinDistanceOf(100, targetArea));
            if (!hasNearbyArea) continue;
            PlotNearbyAreaType type = areaGroup.isSpawn() ? PlotNearbyAreaType.SPAWN : PlotNearbyAreaType.PLOT;
            boolean doAnyOverlap = areaGroup.areas().stream().anyMatch(a -> a.withinDistanceOf(settings.getPlotGap(), targetArea));
            areasToReturn.add(new PlotNearbyAreaMapItem(areaGroup.areas(), type, doAnyOverlap));
        }
        return areasToReturn;
    }

    private Area2D toArea2D(NaturalPlotArea area) {
        Point2D center = new Point2D(area.getX(), area.getZ());
        return AreaUtility.createAreaFromPointAndRadius(center, area.getRadius());
    }
}

