/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.plot;

import com.equestricraft.common.coordinate.Point2D;
import com.equestricraft.core.plot.PlotBlockType;
import com.equestricraft.core.plot.PlotCoordinateUtility;
import java.util.Objects;

public class PlotCoordinate {
    private final int x;
    private final int z;

    public PlotCoordinate(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public PlotCoordinate north() {
        return new PlotCoordinate(this.getX(), this.getZ() - 1);
    }

    public PlotCoordinate south() {
        return new PlotCoordinate(this.getX(), this.getZ() + 1);
    }

    public PlotCoordinate east() {
        return new PlotCoordinate(this.getX() + 1, this.getZ());
    }

    public PlotCoordinate west() {
        return new PlotCoordinate(this.getX() - 1, this.getZ());
    }

    public int getPlotStartX() {
        return this.getX() * 212;
    }

    public int getPlotStartZ() {
        return this.getZ() * 212;
    }

    public int getPlotEndX() {
        return this.getPathStartX() - 1;
    }

    public int getPlotEndZ() {
        return this.getPathStartZ() - 1;
    }

    public int getPathStartX() {
        return this.getPlotStartX() + 201;
    }

    public int getPathStartZ() {
        return this.getPlotStartZ() + 201;
    }

    public int getPathEndX() {
        return this.getPlotStartX() + 212;
    }

    public int getPathEndZ() {
        return this.getPlotStartZ() + 212;
    }

    public PlotBlockType getTypeAtAbsolutePoint(Point2D point) {
        if (point.x() < this.getPlotStartX() || point.x() > this.getPathEndX() || point.z() < this.getPlotStartZ() || point.z() > this.getPathEndZ()) {
            throw new IllegalArgumentException("Point is outwith the plot");
        }
        boolean eastPath = PlotCoordinateUtility.isPlotPath(point.x());
        boolean southPath = PlotCoordinateUtility.isPlotPath(point.z());
        if (eastPath && southPath) {
            return PlotBlockType.PATH_CORNER;
        }
        if (eastPath) {
            return PlotBlockType.PATH_EAST;
        }
        if (southPath) {
            return PlotBlockType.PATH_SOUTH;
        }
        return PlotBlockType.PLOT;
    }

    public PlotBlockType getTypeAtRelativePoint(Point2D point) {
        boolean southPath;
        if (point.x() < 0 || point.x() > 212 || point.z() < 0 || point.z() > 212) {
            throw new IllegalArgumentException("Point is not valid");
        }
        boolean eastPath = point.x() > 201;
        boolean bl = southPath = point.z() > 201;
        if (eastPath && southPath) {
            return PlotBlockType.PATH_CORNER;
        }
        if (eastPath) {
            return PlotBlockType.PATH_EAST;
        }
        if (southPath) {
            return PlotBlockType.PATH_SOUTH;
        }
        return PlotBlockType.PLOT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlotCoordinate that = (PlotCoordinate)o;
        return this.x == that.x && this.z == that.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.z);
    }

    public String toString() {
        return String.format("%s,%s", this.x, this.z);
    }
}

