/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.plot;

import com.equestricraft.common.ECLevel;
import com.equestricraft.common.coordinate.Area2D;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.common.coordinate.Point2D;
import com.equestricraft.core.plot.PlotBlockType;
import com.equestricraft.core.plot.PlotCoordinate;
import java.util.Optional;

public class PlotCoordinateUtility {
    public static Optional<PlotCoordinate> getPlotCoordinate(DirectionalCoordinate coordinate) {
        PlotCoordinate plotCoordinate = PlotCoordinateUtility.getPlotCoordinate(coordinate.getPoint());
        if (plotCoordinate.getTypeAtAbsolutePoint(coordinate.getPoint()) == PlotBlockType.PLOT) {
            return Optional.of(plotCoordinate);
        }
        return Optional.empty();
    }

    public static PlotCoordinate getPlotCoordinate(Point2D point) {
        int plotX = Math.floorDiv(point.x(), 212);
        int plotZ = Math.floorDiv(point.z(), 212);
        return new PlotCoordinate(plotX, plotZ);
    }

    public static boolean isPlotPath(Point2D point) {
        return PlotCoordinateUtility.isPlotPath(point.x()) || PlotCoordinateUtility.isPlotPath(point.z());
    }

    public static boolean isCenterLine(Point2D point2D) {
        PlotCoordinate plot = PlotCoordinateUtility.getPlotCoordinate(point2D);
        DirectionalCoordinate center = PlotCoordinateUtility.getPlotCenter(plot);
        return (double)point2D.x() == center.x() || (double)point2D.z() == center.z();
    }

    public static boolean isPlotPath(int value) {
        int v = value % 212;
        return v >= 201;
    }

    public static DirectionalCoordinate getPlotCenter(PlotCoordinate plotCoordinate) {
        int x = (plotCoordinate.getPlotStartX() + plotCoordinate.getPlotEndX()) / 2;
        int z = (plotCoordinate.getPlotStartZ() + plotCoordinate.getPlotEndZ()) / 2;
        return new DirectionalCoordinate(x, 65.0, z, ECLevel.PLOT_GRID.getIdentifier(), 0.0f, 0.0f);
    }

    public static Area2D getAreaOfPlotCoordinate(PlotCoordinate plotCoordinate) {
        int x1 = plotCoordinate.getX() * 201;
        int z1 = plotCoordinate.getZ() * 201;
        int x2 = x1 + 201;
        int z2 = z1 + 201;
        return new Area2D(x1, x2, z1, z2);
    }

    private PlotCoordinateUtility() {
    }
}

