/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.plot;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.plot.GridPlot;
import com.equestricraft.core.plot.NaturalPlot;
import com.equestricraft.core.plot.NaturalPlotArea;
import com.equestricraft.core.plot.Plot;
import com.equestricraft.core.plot.PlotCoordinate;
import com.equestricraft.core.plot.PlotType;
import java.util.List;

public class PlotDatabase
implements RepositoryDatasource<Plot, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_SPAWN_POINT = "SPAWN_POINT";
    private static final String COLUMN_PLOT_TYPE = "PLOT_TYPE";
    private static final String COLUMN_LOC_X = "LOC_X";
    private static final String COLUMN_LOC_Z = "LOC_Z";
    private static final String COLUMN_RADIUS = "RADIUS";
    private static final String COLUMN_PLOT_ID = "PLOT_ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";

    @Override
    public void create(Plot plot) {
        Query.insertInto("PLOT").columns(QueryColumn.column(COLUMN_NAME, plot.getName()), QueryColumn.column(COLUMN_SPAWN_POINT, plot.getSpawnPoint()), QueryColumn.column(COLUMN_PLOT_TYPE, plot.getPlotType())).executeGetGeneratedKey(plot::setId);
        for (Integer owner : plot.getOwnerIds()) {
            this.createPlotOwner(plot.getId(), owner);
        }
        if (plot instanceof GridPlot) {
            GridPlot gridPlot = (GridPlot)plot;
            for (PlotCoordinate area : gridPlot.getAreas()) {
                this.createPlotArea(plot.getId(), area);
            }
        } else if (plot instanceof NaturalPlot) {
            NaturalPlot naturalPlot = (NaturalPlot)plot;
            for (NaturalPlotArea area : naturalPlot.getPlotAreas()) {
                this.createNaturalPlotArea(plot.getId(), area);
            }
        } else {
            throw new IllegalArgumentException(String.format("Invalid plot type %s for plot %s", plot.getPlotType().name(), plot.getId()));
        }
    }

    private void createPlotArea(int plotId, PlotCoordinate plotCoordinate) {
        Query.insertInto("PLOT_GRID_AREA").columns(QueryColumn.column(COLUMN_LOC_X, plotCoordinate.getX()), QueryColumn.column(COLUMN_LOC_Z, plotCoordinate.getZ()), QueryColumn.column(COLUMN_PLOT_ID, plotId)).execute();
    }

    public void createNaturalPlotArea(int plotId, NaturalPlotArea naturalPlotArea) {
        Query.insertInto("PLOT_NATURAL_AREA").columns(QueryColumn.column(COLUMN_LOC_X, naturalPlotArea.getX()), QueryColumn.column(COLUMN_LOC_Z, naturalPlotArea.getZ()), QueryColumn.column(COLUMN_RADIUS, naturalPlotArea.getRadius()), QueryColumn.column(COLUMN_PLOT_ID, plotId)).executeGetGeneratedKey(naturalPlotArea::setId);
    }

    private void createPlotOwner(int plotId, int ownerId) {
        Query.insertInto("PLOT_OWNER").columns(QueryColumn.column(COLUMN_PLOT_ID, plotId), QueryColumn.column(COLUMN_PLAYER_ID, ownerId)).execute();
    }

    @Override
    public List<Plot> retrieveAll() {
        return Query.selectAllFrom("PLOT").getList(this::getPlotFromResultRow);
    }

    private Plot getPlotFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        DirectionalCoordinate spawnPoint = row.getDirectionalCoordinate(COLUMN_SPAWN_POINT);
        List<Integer> plotOwners = this.getPlotOwners(id);
        PlotType plotType = row.getEnum(COLUMN_PLOT_TYPE, PlotType.class);
        if (plotType == PlotType.GRID) {
            List<PlotCoordinate> plotPositions = this.getPlotPositions(id);
            return new GridPlot(id, name, spawnPoint, plotOwners, plotPositions);
        }
        if (plotType == PlotType.NATURAL) {
            List<NaturalPlotArea> plotAreas = this.getNaturalPlotAreas(id);
            return new NaturalPlot(id, name, spawnPoint, plotOwners, plotAreas);
        }
        throw new IllegalArgumentException(String.format("Invalid plot type %s for plot %s", plotType.name(), id));
    }

    private List<PlotCoordinate> getPlotPositions(int plotId) {
        return Query.selectAllFrom("PLOT_GRID_AREA").where(QueryColumn.column(COLUMN_PLOT_ID, plotId)).getList(this::getCoordinateFromResultRow);
    }

    private PlotCoordinate getCoordinateFromResultRow(ResultRow row) {
        int locX = row.getInt(COLUMN_LOC_X);
        int locZ = row.getInt(COLUMN_LOC_Z);
        return new PlotCoordinate(locX, locZ);
    }

    private List<NaturalPlotArea> getNaturalPlotAreas(int plotId) {
        return Query.selectAllFrom("PLOT_NATURAL_AREA").where(QueryColumn.column(COLUMN_PLOT_ID, plotId)).getList(this::getNaturalPlotArea);
    }

    private NaturalPlotArea getNaturalPlotArea(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int locX = row.getInt(COLUMN_LOC_X);
        int locZ = row.getInt(COLUMN_LOC_Z);
        int radius = row.getInt(COLUMN_RADIUS);
        return new NaturalPlotArea(id, locX, locZ, radius);
    }

    private List<Integer> getPlotOwners(int plotId) {
        return Query.selectAllFrom("PLOT_OWNER").where(QueryColumn.column(COLUMN_PLOT_ID, plotId)).getList(row -> row.getInt(COLUMN_PLAYER_ID));
    }

    @Override
    public void update(Plot plot) {
        Query.update("PLOT").set(QueryColumn.column(COLUMN_NAME, plot.getName()), QueryColumn.column(COLUMN_SPAWN_POINT, plot.getSpawnPoint())).where(QueryColumn.column(COLUMN_ID, plot.getId())).execute();
        this.setPlotOwners(plot.getId(), plot.getOwnerIds());
        if (plot instanceof GridPlot) {
            GridPlot gridPlot = (GridPlot)plot;
            this.setPlotPositions(plot.getId(), gridPlot.getAreas());
        }
    }

    private void setPlotPositions(int plotId, List<PlotCoordinate> positions) {
        Query.deleteFrom("PLOT_GRID_AREA").where(QueryColumn.column(COLUMN_PLOT_ID, plotId)).execute();
        for (PlotCoordinate position : positions) {
            this.createPlotArea(plotId, position);
        }
    }

    private void setPlotOwners(int plotId, List<Integer> ownerIds) {
        Query.deleteFrom("PLOT_OWNER").where(QueryColumn.column(COLUMN_PLOT_ID, plotId)).execute();
        for (Integer owner : ownerIds) {
            this.createPlotOwner(plotId, owner);
        }
    }

    @Override
    public void deleteByKey(Integer integer) {
        Query.deleteFrom("PLOT").where(QueryColumn.column(COLUMN_ID, integer)).execute();
    }
}

