/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.plot;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.plot.Plot;
import com.equestricraft.core.plot.PlotPermissionException;
import com.equestricraft.core.plot.access.PlotAccessLevel;
import com.equestricraft.core.plot.access.PlotPlayerAccessSession;

public class PlotPermissionChecker {
    @Service
    private static PlotPlayerAccessSession plotPlayerAccessSession;

    public static void ensureBasicAccess(ECPlayer player, Plot plot) throws PlotPermissionException {
        PlotPermissionChecker.ensurePlayerAtLeastAccessLevel(player, plot, PlotAccessLevel.ACCESS);
    }

    public static boolean hasBasicAccess(ECPlayer player, Plot plot) {
        return PlotPermissionChecker.doesPlayerHaveAtLeastAccessLevel(player, plot, PlotAccessLevel.ACCESS);
    }

    public static void ensureEditAccess(ECPlayer player, Plot plot) throws PlotPermissionException {
        PlotPermissionChecker.ensurePlayerAtLeastAccessLevel(player, plot, PlotAccessLevel.EDIT);
    }

    public static boolean hasEditAccess(ECPlayer player, Plot plot) {
        return PlotPermissionChecker.doesPlayerHaveAtLeastAccessLevel(player, plot, PlotAccessLevel.EDIT);
    }

    public static void ensureOwnerAccess(ECPlayer player, Plot plot) throws PlotPermissionException {
        PlotPermissionChecker.ensurePlayerAtLeastAccessLevel(player, plot, PlotAccessLevel.OWNER);
    }

    public static boolean hasOwnerAccess(ECPlayer player, Plot plot) {
        return PlotPermissionChecker.doesPlayerHaveAtLeastAccessLevel(player, plot, PlotAccessLevel.OWNER);
    }

    private static void ensurePlayerAtLeastAccessLevel(ECPlayer player, Plot plot, PlotAccessLevel accessLevel) throws PlotPermissionException {
        if (!PlotPermissionChecker.doesPlayerHaveAtLeastAccessLevel(player, plot, accessLevel)) {
            throw new PlotPermissionException(I18n.getLabel("plot.no-permission"));
        }
    }

    private static boolean doesPlayerHaveAtLeastAccessLevel(ECPlayer player, Plot plot, PlotAccessLevel accessLevel) {
        PlotAccessLevel playersAccessLevel = plotPlayerAccessSession.retrievePlayersAccessLevelToPlot(player, plot);
        return playersAccessLevel.isAtLeast(accessLevel);
    }

    private PlotPermissionChecker() {
    }
}

