/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.plot;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.base.repository.RepositoryUpdatePolicy;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.plot.GridPlot;
import com.equestricraft.core.plot.NaturalPlot;
import com.equestricraft.core.plot.NaturalPlotArea;
import com.equestricraft.core.plot.Plot;
import com.equestricraft.core.plot.PlotCoordinate;
import com.equestricraft.core.plot.PlotDatabase;
import java.util.List;
import java.util.Optional;

public class PlotRepository
extends Repository<Plot, Integer> {
    @Service
    private PlotDatabase plotDatabase;

    @Override
    protected RepositoryDatasource<Plot, Integer> getDatasource() {
        return this.plotDatabase;
    }

    @Override
    protected RepositoryUpdatePolicy updatePolicy() {
        return RepositoryUpdatePolicy.REPLACE;
    }

    public void addAreaToPlot(NaturalPlot plot, NaturalPlotArea plotArea) {
        this.plotDatabase.createNaturalPlotArea(plot.getId(), plotArea);
        plot.getPlotAreas().add(plotArea);
    }

    public List<Plot> findByOwner(int playerId) {
        return this.findListByPredicates((T p) -> p.getOwnerIds().contains(playerId));
    }

    public Optional<GridPlot> findGridPlotByCoordinate(PlotCoordinate plotCoordinate) {
        RepositorySearchQuery<Plot> query = this.createSearchQuery();
        query.filter(p -> {
            GridPlot gridPlot;
            return p instanceof GridPlot && (gridPlot = (GridPlot)p).getAreas().contains(plotCoordinate);
        });
        return query.castedSingle(GridPlot.class);
    }

    public List<GridPlot> findAllGridPlots() {
        RepositorySearchQuery<Plot> query = this.createSearchQuery();
        query.filter(GridPlot.class::isInstance);
        return query.castedMany(GridPlot.class);
    }

    public List<NaturalPlot> findAllNaturalPlots() {
        RepositorySearchQuery<Plot> query = this.createSearchQuery();
        query.filter(NaturalPlot.class::isInstance);
        return query.castedMany(NaturalPlot.class);
    }
}

