/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.plot;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.coordinate.Area2D;
import com.equestricraft.common.coordinate.AreaUtility;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.common.coordinate.Point2D;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.StringUtils;
import com.equestricraft.core.blockedphrase.BlockedPhraseException;
import com.equestricraft.core.blockedphrase.BlockedPhraseService;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.economy.SingleAccountEconomyResponse;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.core.player.PlayerTransformer;
import com.equestricraft.core.plot.GridPlot;
import com.equestricraft.core.plot.InvalidPlotLocationException;
import com.equestricraft.core.plot.NaturalPlot;
import com.equestricraft.core.plot.NaturalPlotArea;
import com.equestricraft.core.plot.Plot;
import com.equestricraft.core.plot.PlotAlreadyOwnedException;
import com.equestricraft.core.plot.PlotAreaSession;
import com.equestricraft.core.plot.PlotBlockType;
import com.equestricraft.core.plot.PlotCoordinate;
import com.equestricraft.core.plot.PlotCoordinateUtility;
import com.equestricraft.core.plot.PlotException;
import com.equestricraft.core.plot.PlotInfo;
import com.equestricraft.core.plot.PlotPurchaseResponse;
import com.equestricraft.core.plot.PlotRepository;
import com.equestricraft.core.plot.PlotSession;
import com.equestricraft.core.plot.PlotType;
import com.equestricraft.core.plot.access.PlotPlayerAccessSession;
import com.equestricraft.core.plot.setting.PlotGlobalSettings;
import com.equestricraft.logging.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;

public class PlotSessionImpl
implements PlotSession {
    @Service
    private PlotRepository plotRepository;
    @Service
    private PlotPlayerAccessSession plotPlayerAccessSession;
    @Service
    private PlayerRepository playerRepository;
    @Service
    private PlayerTransformer playerTransformer;
    @Service
    private PlotAreaSession plotAreaSession;
    @Service
    private BlockedPhraseService blockedPhraseService;
    private final ReentrantLock gridPlotPurchaseLock = new ReentrantLock();
    private final ReentrantLock naturalPlotPurchaseLock = new ReentrantLock();
    private static final Log log = Log.getLogger(PlotSessionImpl.class.getName());

    @Override
    public PlotPurchaseResponse purchaseNewGridPlot(ECPlayer player, DirectionalCoordinate directionalCoordinate, String name) throws PlotException {
        PlotCoordinate plotCoordinate = PlotCoordinateUtility.getPlotCoordinate(directionalCoordinate).orElseThrow(InvalidPlotLocationException::new);
        this.gridPlotPurchaseLock.lock();
        try {
            Optional<GridPlot> existing = this.plotRepository.findGridPlotByCoordinate(plotCoordinate);
            if (existing.isPresent()) {
                throw new PlotAlreadyOwnedException();
            }
            name = StringUtils.removeExtraSpaces(name);
            this.blockedPhraseService.ensureNoBlockedPhrases(name);
            List<PlotCoordinate> areas = this.createSingletonGridAreaList(plotCoordinate);
            List<Integer> owners = this.createSingletonOwnerList(player);
            GridPlot plot = new GridPlot(0, name, directionalCoordinate, owners, areas);
            double gridPrice = PlotGlobalSettings.get().getGridPrice();
            SingleAccountEconomyResponse economyResponse = player.getEconomy().withdraw(gridPrice, I18n.getLabel("plot.purchase.economy-line", name), "Plot");
            plot = this.plotRepository.add(plot);
            PlotPurchaseResponse plotPurchaseResponse = new PlotPurchaseResponse(economyResponse, plot);
            return plotPurchaseResponse;
        }
        catch (EconomyException ex) {
            throw new PlotException(ex.getMessage());
        }
        catch (BlockedPhraseException ex) {
            throw new PlotException(ex);
        }
        finally {
            this.gridPlotPurchaseLock.unlock();
        }
    }

    @Override
    public PlotPurchaseResponse autoPurchaseGridPlot(ECPlayer player, String name) throws PlotException {
        this.gridPlotPurchaseLock.lock();
        try {
            PlotCoordinate freeCoordinate = this.getAvailablePlot();
            List<PlotCoordinate> areas = this.createSingletonGridAreaList(freeCoordinate);
            List<Integer> owners = this.createSingletonOwnerList(player);
            DirectionalCoordinate plotCenter = PlotCoordinateUtility.getPlotCenter(freeCoordinate);
            name = StringUtils.removeExtraSpaces(name);
            this.blockedPhraseService.ensureNoBlockedPhrases(name);
            GridPlot plot = new GridPlot(0, name, plotCenter, owners, areas);
            double gridPrice = PlotGlobalSettings.get().getGridPrice();
            SingleAccountEconomyResponse economyResponse = player.getEconomy().withdraw(gridPrice, I18n.getLabel("plot.purchase.economy-line", name), "Plot");
            plot = this.plotRepository.add(plot);
            PlotPurchaseResponse plotPurchaseResponse = new PlotPurchaseResponse(economyResponse, plot);
            return plotPurchaseResponse;
        }
        catch (EconomyException ex) {
            throw new PlotException(ex.getMessage());
        }
        catch (BlockedPhraseException ex) {
            throw new PlotException(ex);
        }
        finally {
            this.gridPlotPurchaseLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Plot autoGiveGridPlot(ECPlayer player) {
        this.gridPlotPurchaseLock.lock();
        try {
            PlotCoordinate freeCoordinate = this.getAvailablePlot();
            List<PlotCoordinate> areas = this.createSingletonGridAreaList(freeCoordinate);
            List<Integer> owners = this.createSingletonOwnerList(player);
            DirectionalCoordinate plotCenter = PlotCoordinateUtility.getPlotCenter(freeCoordinate);
            GridPlot plot = new GridPlot(0, I18n.getLabel("plot.my-first-plot"), plotCenter, owners, areas);
            GridPlot gridPlot = plot = this.plotRepository.add(plot);
            return gridPlot;
        }
        finally {
            this.gridPlotPurchaseLock.unlock();
        }
    }

    private PlotCoordinate getAvailablePlot() {
        List<GridPlot> allPlots = this.plotRepository.findAllGridPlots();
        List usedCoordinates = allPlots.stream().flatMap(p -> p.getAreas().stream()).toList();
        int checked = 0;
        for (int x = 1000; x <= 1100; ++x) {
            for (int z = 1000; z <= 2000; ++z) {
                PlotCoordinate coordinate = new PlotCoordinate(x, z);
                if (!usedCoordinates.contains(coordinate)) {
                    return coordinate;
                }
                if (++checked % 10000 != 0) continue;
                log.warn("Have already checked {} plot locations for plot auto", (Object)checked);
            }
        }
        log.error("Could not find a suitable plot for auto plot, all possible plots have been exhausted");
        throw new IllegalArgumentException("Plots exhausted");
    }

    private List<PlotCoordinate> createSingletonGridAreaList(PlotCoordinate plotCoordinate) {
        ArrayList<PlotCoordinate> coordinates = new ArrayList<PlotCoordinate>(1);
        coordinates.add(plotCoordinate);
        return coordinates;
    }

    private List<Integer> createSingletonOwnerList(ECPlayer player) {
        ArrayList<Integer> owners = new ArrayList<Integer>(1);
        owners.add(player.getId());
        return owners;
    }

    @Override
    public PlotPurchaseResponse purchaseNewNaturalPlot(ECPlayer player, DirectionalCoordinate directionalCoordinate, String name, int radius) throws PlotException {
        this.naturalPlotPurchaseLock.lock();
        try {
            this.ensureValidRadiusSize(radius);
            NaturalPlotArea area = this.createNaturalPlotArea(directionalCoordinate, radius);
            ArrayList<NaturalPlotArea> plotAreas = new ArrayList<NaturalPlotArea>(1);
            plotAreas.add(area);
            List<Integer> owners = this.createSingletonOwnerList(player);
            name = StringUtils.removeExtraSpaces(name);
            this.blockedPhraseService.ensureNoBlockedPhrases(name);
            NaturalPlot plot = new NaturalPlot(0, name, directionalCoordinate, owners, plotAreas);
            this.ensureSpaceIsAvailable(area, null);
            double totalCost = this.calculateCost(area);
            try {
                SingleAccountEconomyResponse response = player.getEconomy().withdraw(totalCost, I18n.getLabel("plot.purchase.economy-line", name), "Plot");
                this.plotRepository.add(plot);
                PlotPurchaseResponse plotPurchaseResponse = new PlotPurchaseResponse(response, plot);
                return plotPurchaseResponse;
            }
            catch (EconomyException ex) {
                try {
                    throw new PlotException(ex.getMessage());
                }
                catch (BlockedPhraseException ex2) {
                    throw new PlotException(ex2);
                }
            }
        }
        finally {
            this.naturalPlotPurchaseLock.unlock();
        }
    }

    private NaturalPlotArea createNaturalPlotArea(DirectionalCoordinate directionalCoordinate, int radius) {
        int x = (int)directionalCoordinate.x();
        int z = (int)directionalCoordinate.z();
        return new NaturalPlotArea(0, x, z, radius);
    }

    private void ensureValidRadiusSize(int radius) throws PlotException {
        PlotGlobalSettings settings = PlotGlobalSettings.get();
        if (radius < settings.getMinimumPlotRadius()) {
            throw new PlotException(I18n.getLabel("plot.purchase.radius-too-small", settings.getMinimumPlotRadius()));
        }
    }

    private void ensureSpaceIsAvailable(NaturalPlotArea plotArea, Integer excludePlotId) throws PlotException {
        Area2D plot2DArea = this.toArea2D(plotArea);
        this.ensureNoNearbyPlots(plot2DArea, excludePlotId);
        this.ensureNotNearSpawn(plot2DArea);
    }

    private void ensureNoNearbyPlots(Area2D plot2DArea, Integer excludePlotId) throws PlotException {
        PlotGlobalSettings settings = PlotGlobalSettings.get();
        List<NaturalPlot> allPlots = this.plotRepository.findAllNaturalPlots();
        for (NaturalPlot otherPlot : allPlots) {
            if (excludePlotId != null && excludePlotId.intValue() == otherPlot.getId()) continue;
            for (NaturalPlotArea otherPlotArea : otherPlot.getPlotAreas()) {
                Area2D otherPlot2DArea = this.toArea2D(otherPlotArea);
                if (plot2DArea.overlapsWith(otherPlot2DArea)) {
                    throw new PlotException(I18n.getLabel("plot.conflict.detected"));
                }
                if (!plot2DArea.withinDistanceOf(settings.getPlotGap(), otherPlot2DArea)) continue;
                throw new PlotException(I18n.getLabel("plot.proximity.too-close"));
            }
        }
    }

    private void ensureNotNearSpawn(Area2D plot2DArea) throws PlotException {
        PlotGlobalSettings settings = PlotGlobalSettings.get();
        DirectionalCoordinate spawnPoint = settings.getSpawnPoint();
        int radius = settings.getSpawnPointProtectionRadius();
        Area2D spawnArea = AreaUtility.createAreaFromPointAndRadius(new Point2D((int)spawnPoint.x(), (int)spawnPoint.z()), radius);
        if (plot2DArea.overlapsWith(spawnArea)) {
            throw new PlotException(I18n.getLabel("plot.conflict.in-spawn"));
        }
    }

    private double calculateCost(NaturalPlotArea plotArea) {
        return this.calculateCost(plotArea.getRadius());
    }

    @Override
    public double calculateCost(int radius) {
        double size = this.calculateSize(radius);
        double pricePerSquare = PlotGlobalSettings.get().getPricePerSquare();
        return size * pricePerSquare;
    }

    private double calculateSize(int radius) {
        int length = radius * 2 + 1;
        return Math.pow(length, 2.0);
    }

    @Override
    public double addAreaToPlot(int plotId, int x, int z, int radius) throws PlotException {
        NaturalPlotArea newPlotArea;
        NaturalPlot plot = (NaturalPlot)this.plotRepository.findByKey(plotId);
        boolean overlaps = this.doesAreaOverlapWithPlot(plot, newPlotArea = new NaturalPlotArea(0, x, z, radius));
        if (!overlaps) {
            throw new PlotException(I18n.getLabel("plot.add-area.no-overlap"));
        }
        this.ensureSpaceIsAvailable(newPlotArea, plotId);
        double cost = this.calculateNewAreaCost(plot, newPlotArea);
        if (cost <= 0.0) {
            throw new PlotException(I18n.getLabel("plot.add-area.no-new-blocks"));
        }
        List<CorePlayer> owners = plot.getOwners();
        double costPerPlayer = cost / (double)owners.size();
        this.ensureOwnersHaveEnough(owners, costPerPlayer);
        this.withdrawMoneyFromOwners(plot, owners, costPerPlayer);
        this.plotRepository.addAreaToPlot(plot, newPlotArea);
        return cost;
    }

    private boolean doesAreaOverlapWithPlot(NaturalPlot plot, NaturalPlotArea plotArea) {
        Area2D newPlotArea2D = this.toArea2D(plotArea);
        List<Area2D> existingAreas = this.plotAreaSession.retrieveAreasForPlot(plot);
        return existingAreas.stream().anyMatch(newPlotArea2D::overlapsWith);
    }

    @Override
    public double calculateNewAreaCost(NaturalPlot plot, NaturalPlotArea newPlotArea) {
        int newSquares = this.countNewSquaresNotInExistingAreas(newPlotArea, plot.getPlotAreas());
        double pricePerSquare = PlotGlobalSettings.get().getPricePerSquare();
        return (double)newSquares * pricePerSquare;
    }

    private int countNewSquaresNotInExistingAreas(NaturalPlotArea newPlotArea, List<NaturalPlotArea> existingAreas) {
        Area2D newArea = this.toArea2D(newPlotArea);
        long countOfSquaresWithOverlap = existingAreas.stream().map(this::toArea2D).filter(newArea::overlapsWith).map(a -> AreaUtility.createIntersection(a, newArea)).flatMap(intersection -> AreaUtility.listOfPointsInArea(intersection).stream()).distinct().count();
        return Math.max((int)((long)newArea.size() - countOfSquaresWithOverlap), 0);
    }

    private void ensureOwnersHaveEnough(List<CorePlayer> owners, double costPerPlayer) throws PlotException {
        ArrayList<String> ignsNotEnoughMoney = new ArrayList<String>(owners.size());
        for (CorePlayer owner : owners) {
            if (owner.getEconomy().hasBalance(costPerPlayer)) continue;
            ignsNotEnoughMoney.add(owner.getIgn());
        }
        if (!ignsNotEnoughMoney.isEmpty()) {
            throw new PlotException(I18n.getLabel("plot.owner-money-check.some-owners-not-enough", String.join((CharSequence)", ", ignsNotEnoughMoney)));
        }
    }

    private void withdrawMoneyFromOwners(Plot plot, List<CorePlayer> owners, double costPerPlayer) throws PlotException {
        for (CorePlayer owner : owners) {
            try {
                owner.getEconomy().withdraw(costPerPlayer, I18n.getLabel("plot.add-area.economy-line", plot.getName()), "Plot");
            }
            catch (EconomyException ex) {
                throw new PlotException(ex.getMessage());
            }
        }
    }

    @Override
    public void sellPlot(Plot plot, List<ECPlayer> playersSellingTo, double price) throws PlotException {
        this.ensureNotSellingToAnExistingOwner(playersSellingTo, plot);
        this.withdrawFromNewOwners(plot, playersSellingTo, price);
        this.payCurrentOwners(plot, price, I18n.getLabel("plot.sell.economy-line", plot.getName()));
        this.transferPlot(playersSellingTo, plot);
    }

    @Override
    public void mergePlotIntoPlot(GridPlot targetPlot, GridPlot sourcePlot) throws PlotException {
        if (sourcePlot.getOwnerIds().size() != 1) {
            throw new PlotException(I18n.getLabel("plot.merge.source-only-one-owner"));
        }
        if (!targetPlot.getOwnerIds().contains(sourcePlot.getOwnerIds().get(0))) {
            throw new PlotException(I18n.getLabel("plot.merge.source-target-owner-must-match"));
        }
        targetPlot.getAreas().addAll(sourcePlot.getAreas());
        this.plotRepository.remove(sourcePlot);
        this.removePlotFromPlayers(sourcePlot);
        targetPlot.save();
    }

    @Override
    public void removePlotFromPlayers(Plot plot) {
        for (CorePlayer player : this.playerRepository) {
            Optional<Plot> p = player.getPlots().getCurrentPlot();
            if (!p.isPresent() || !p.get().equals(plot)) continue;
            player.getPlots().setCurrentPlot(null);
        }
    }

    private void ensureNotSellingToAnExistingOwner(List<ECPlayer> playersSellingTo, Plot plot) throws PlotException {
        for (ECPlayer player : playersSellingTo) {
            if (!plot.getOwnerIds().contains(player.getId())) continue;
            throw new PlotException(I18n.getLabel("plot.sell.cannot-sell-to-same-player"));
        }
    }

    private void withdrawFromNewOwners(Plot plot, List<ECPlayer> playersSellingTo, double totalPrice) throws PlotException {
        double pricePerPlayer = totalPrice / (double)playersSellingTo.size();
        this.ensureNewOwnersHaveEnoughMoney(playersSellingTo, pricePerPlayer);
        String transactionMessage = I18n.getLabel("plot.sell.economy-line", plot.getName());
        for (ECPlayer player : playersSellingTo) {
            try {
                player.getEconomy().withdraw(pricePerPlayer, transactionMessage, "Plot");
            }
            catch (EconomyException ex) {
                throw new PlotException(ex.getMessage());
            }
        }
    }

    private void ensureNewOwnersHaveEnoughMoney(List<ECPlayer> playersSellingTo, double pricePerPlayer) throws PlotException {
        ArrayList<String> ignsNotEnoughMoney = new ArrayList<String>(playersSellingTo.size());
        for (ECPlayer player : playersSellingTo) {
            if (player.getEconomy().hasBalance(pricePerPlayer)) continue;
            ignsNotEnoughMoney.add(player.getIgn());
        }
        if (!ignsNotEnoughMoney.isEmpty()) {
            throw new PlotException(I18n.getLabel("plot.sell.not-enough-money"));
        }
    }

    private void payCurrentOwners(Plot plot, double price, String transactionMessage) {
        List<CorePlayer> currentOwners = plot.getOwners();
        double paymentPerPlayer = price / (double)currentOwners.size();
        for (CorePlayer player : currentOwners) {
            player.getEconomy().deposit(paymentPerPlayer, transactionMessage, "Plot");
        }
    }

    private void transferPlot(List<ECPlayer> playersSellingTo, Plot plot) {
        List<Integer> newOwnerIds = playersSellingTo.stream().map(ECPlayer::getId).toList();
        plot.setOwnerIds(newOwnerIds);
        plot.save();
    }

    @Override
    public Optional<Plot> getPlotAtPoint(PlotType plotType, Point2D point2D) {
        return switch (plotType) {
            default -> throw new IncompatibleClassChangeError();
            case PlotType.GRID -> {
                Optional<GridPlot> gridPlot = this.getGridPlotAtPoint(point2D);
                yield Optional.ofNullable(gridPlot.orElse(null));
            }
            case PlotType.NATURAL -> {
                Optional<NaturalPlot> naturalPlot = this.getNaturalPlotAtPoint(point2D);
                yield Optional.ofNullable(naturalPlot.orElse(null));
            }
        };
    }

    private Optional<GridPlot> getGridPlotAtPoint(Point2D point) {
        PlotCoordinate coordinate = PlotCoordinateUtility.getPlotCoordinate(point);
        PlotBlockType position = coordinate.getTypeAtAbsolutePoint(point);
        Optional<GridPlot> plot = this.plotRepository.findGridPlotByCoordinate(coordinate);
        if (position == PlotBlockType.PLOT) {
            return plot;
        }
        if (plot.isPresent()) {
            List<PlotCoordinate> areas = plot.get().getAreas();
            boolean containsSouthArea = areas.contains(coordinate.south());
            boolean containsEastArea = areas.contains(coordinate.east());
            boolean containsSouthEastArea = areas.contains(coordinate.south().east());
            if (position == PlotBlockType.PATH_SOUTH && containsSouthArea || position == PlotBlockType.PATH_EAST && containsEastArea || position == PlotBlockType.PATH_CORNER && containsSouthArea && containsSouthEastArea && containsEastArea) {
                return plot;
            }
        }
        return Optional.empty();
    }

    private Optional<NaturalPlot> getNaturalPlotAtPoint(Point2D point2D) {
        List<NaturalPlot> allPlots = this.plotRepository.findAllNaturalPlots();
        for (NaturalPlot plot : allPlots) {
            for (NaturalPlotArea plotArea : plot.getPlotAreas()) {
                Area2D plotArea2D = this.toArea2D(plotArea);
                if (!plotArea2D.containsPoint(point2D)) continue;
                return Optional.of(plot);
            }
        }
        return Optional.empty();
    }

    private Area2D toArea2D(NaturalPlotArea plotArea) {
        Point2D centerPoint = new Point2D(plotArea.getX(), plotArea.getZ());
        return AreaUtility.createAreaFromPointAndRadius(centerPoint, plotArea.getRadius());
    }

    @Override
    public List<PlotInfo> retrievePlotsForPlayersList(ECPlayer player) {
        List<Plot> ownedPlots = this.plotRepository.findByOwner(player.getId());
        List<PlotInfo> ownedPlotInfos = ownedPlots.stream().map(this::createInfoForPlot).toList();
        List<Integer> accessPlotIds = this.plotPlayerAccessSession.retrievePlotsPlayerHasAccessTo(player);
        List accessPlots = this.plotRepository.findByKeys(accessPlotIds);
        List<PlotInfo> accessPlotInfos = accessPlots.stream().map(this::createInfoForPlot).toList();
        ArrayList<PlotInfo> plots = new ArrayList<PlotInfo>(ownedPlotInfos.size() + accessPlotInfos.size());
        plots.addAll(ownedPlotInfos);
        plots.addAll(accessPlotInfos);
        return plots;
    }

    @Override
    public List<PlotInfo> retrieveNeighbouringPlots(GridPlot plot) {
        ArrayList<Plot> neighbouringPlots = new ArrayList<Plot>();
        for (PlotCoordinate area : plot.getAreas()) {
            Optional<GridPlot> westPlot;
            Optional<GridPlot> eastPlot;
            Optional<GridPlot> southPlot;
            Optional<GridPlot> northPlot = this.plotRepository.findGridPlotByCoordinate(area.north());
            if (northPlot.isPresent() && !northPlot.get().equals(plot) && !neighbouringPlots.contains(northPlot.get())) {
                neighbouringPlots.add(northPlot.get());
            }
            if ((southPlot = this.plotRepository.findGridPlotByCoordinate(area.south())).isPresent() && !southPlot.get().equals(plot) && !neighbouringPlots.contains(southPlot.get())) {
                neighbouringPlots.add(southPlot.get());
            }
            if ((eastPlot = this.plotRepository.findGridPlotByCoordinate(area.east())).isPresent() && !eastPlot.get().equals(plot) && !neighbouringPlots.contains(eastPlot.get())) {
                neighbouringPlots.add(eastPlot.get());
            }
            if (!(westPlot = this.plotRepository.findGridPlotByCoordinate(area.west())).isPresent() || westPlot.get().equals(plot) || neighbouringPlots.contains(westPlot.get())) continue;
            neighbouringPlots.add(westPlot.get());
        }
        return neighbouringPlots.stream().map(this::createInfoForPlot).toList();
    }

    @Override
    public PlotInfo createInfoForPlot(Plot plot) {
        List<PlayerSimple> ownerInfoList = plot.getOwners().stream().map(this.playerTransformer::toSimple).toList();
        return new PlotInfo(plot.getId(), plot.getName(), plot.getPlotType(), ownerInfoList);
    }

    @Override
    public void sendNotificationToPlotOwners(Plot plot, String message) {
        plot.getOwners().forEach(owner -> owner.notify(message));
    }

    @Override
    public void removePlayerAsOwner(Plot plot, ECPlayer player) throws PlotException {
        this.ensureNotOnlyOwner(plot);
        plot.getOwnerIds().removeIf(o -> o.intValue() == player.getId());
        this.plotPlayerAccessSession.grantPlayerEditAccessToPlot(player, plot);
        this.sendNotificationToPlotOwners(plot, I18n.getLabel("plot.step-down-as-owner.notification", player.getIgn(), plot.getName()));
    }

    private void ensureNotOnlyOwner(Plot plot) throws PlotException {
        if (plot.getOwnerIds().size() == 1) {
            throw new PlotException(I18n.getLabel("plot.step-down-as-owner.you-are-only-owner"));
        }
    }

    @Override
    public void deletePlot(Plot plot) {
        this.plotRepository.remove(plot);
        double price = this.calculateRefundForPlotDelete(plot);
        this.payCurrentOwners(plot, price, I18n.getLabel("plot.delete.economy-line", plot.getName()));
    }

    private double calculateRefundForPlotDelete(Plot plot) {
        if (plot instanceof GridPlot) {
            GridPlot gridPlot = (GridPlot)plot;
            double price = PlotGlobalSettings.get().getGridPrice();
            return price * (double)gridPlot.getAreas().size();
        }
        throw new IllegalArgumentException(String.format("Invalid plot type %s for plot %s", plot.getClass().getName(), plot.getId()));
    }
}

