/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.plot;

import com.equestricraft.common.ECLevel;
import java.util.Optional;

public enum PlotType {
    GRID(ECLevel.PLOT_GRID),
    NATURAL(ECLevel.PLOT_NATURAL);

    private final ECLevel level;

    private PlotType(ECLevel level) {
        this.level = level;
    }

    public ECLevel getLevel() {
        return this.level;
    }

    public static PlotType requirePlotTypeForLevel(ECLevel level) {
        return PlotType.getPlotTypeForLevel(level).orElseThrow(() -> new IllegalArgumentException(String.format("Not a plot level: %s", level.name())));
    }

    public static Optional<PlotType> getPlotTypeForLevel(ECLevel level) {
        return Optional.ofNullable(switch (level) {
            case ECLevel.PLOT_GRID -> GRID;
            case ECLevel.PLOT_NATURAL -> NATURAL;
            default -> null;
        });
    }
}

