/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.plot.access;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.plot.access.PlotPlayerAccess;
import com.equestricraft.core.plot.access.PlotPlayerAccessKey;
import java.util.List;

public class PlotPlayerAccessDatabase
implements RepositoryDatasource<PlotPlayerAccess, PlotPlayerAccessKey> {
    private static final String COLUMN_PLOT_ID = "PLOT_ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_EDIT = "EDIT";

    @Override
    public void create(PlotPlayerAccess plotPlayerAccess) {
        Query.insertInto("PLOT_PLAYER_ACCESS").columns(QueryColumn.column(COLUMN_PLOT_ID, plotPlayerAccess.getPlotId()), QueryColumn.column(COLUMN_PLAYER_ID, plotPlayerAccess.getPlayerId()), QueryColumn.column(COLUMN_EDIT, plotPlayerAccess.isEdit())).execute();
    }

    @Override
    public List<PlotPlayerAccess> retrieveAll() {
        return Query.selectAllFrom("PLOT_PLAYER_ACCESS").getList(this::getPlotPlayerAccessFromResultRow);
    }

    private PlotPlayerAccess getPlotPlayerAccessFromResultRow(ResultRow row) {
        int plotId = row.getInt(COLUMN_PLOT_ID);
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        boolean edit = row.getBoolean(COLUMN_EDIT);
        return new PlotPlayerAccess(plotId, playerId, edit);
    }

    @Override
    public void update(PlotPlayerAccess plotPlayerAccess) {
        Query.update("PLOT_PLAYER_ACCESS").set(QueryColumn.column(COLUMN_EDIT, plotPlayerAccess.isEdit())).where(QueryColumn.column(COLUMN_PLOT_ID, plotPlayerAccess.getPlotId()), QueryColumn.column(COLUMN_PLAYER_ID, plotPlayerAccess.getPlayerId())).execute();
    }

    @Override
    public void deleteByKey(PlotPlayerAccessKey plotPlayerAccessKey) {
        Query.deleteFrom("PLOT_PLAYER_ACCESS").where(QueryColumn.column(COLUMN_PLOT_ID, plotPlayerAccessKey.plotId()), QueryColumn.column(COLUMN_PLAYER_ID, plotPlayerAccessKey.playerId())).execute();
    }
}

